/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aVF;
import com.aspose.html.utils.aVG;
import com.aspose.html.utils.aVH;
import com.aspose.html.utils.aVI;
import com.aspose.html.utils.aVJ;
import com.aspose.html.utils.aVK;
import com.aspose.html.utils.aVL;
import com.aspose.html.utils.aVM;
import com.aspose.html.utils.aVN;
import com.aspose.html.utils.aVO;
import com.aspose.html.utils.aYH;
import com.aspose.html.utils.aYK;
import com.aspose.html.utils.aYS;
import com.aspose.html.utils.aYT;
import com.aspose.html.utils.bgx;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class aVo {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public aVo(final PublicKey publicKey, final PrivateKey privateKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                aVo.this.checkKeyPairForConsistency(publicKey, privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECKey && privateKey instanceof ECKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            if (!(eCPrivateKey.getParams().getCurve().equals(eCPublicKey.getParams().getCurve()) && eCPrivateKey.getParams().getGenerator().equals(eCPublicKey.getParams().getGenerator()) && eCPrivateKey.getParams().getOrder().equals(eCPublicKey.getParams().getOrder()) && eCPrivateKey.getParams().getCofactor() == eCPublicKey.getParams().getCofactor())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            aYK aYK2 = new aYK(eCPrivateKey.getParams());
            if (aYK2.bkn().bib().i(eCPrivateKey.getS()).brE().h(aYK2.bkn().bia().l(eCPublicKey.getW().getAffineX(), eCPublicKey.getW().getAffineY()))) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof DHKey && privateKey instanceof DHKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            if (!dHParameterSpec.getG().equals(dHPublicKey.getParams().getG()) && !dHParameterSpec.getP().equals(dHPublicKey.getParams().getP())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHParameterSpec.getG().modPow(dHPrivateKey.getX(), dHParameterSpec.getP()).equals(dHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof DSAKey && privateKey instanceof DSAKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPrivateKey.getParams();
            if (!(dSAParams.getG().equals(dSAPublicKey.getParams().getG()) || dSAParams.getP().equals(dSAPublicKey.getParams().getP()) || dSAParams.getQ().equals(dSAPublicKey.getParams().getQ()))) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSAParams.getG().modPow(dSAPrivateKey.getX(), dSAParams.getP()).equals(dSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof RSAKey && privateKey instanceof RSAKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            if (!rSAPrivateKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getModulus()).modPow(rSAPublicKey.getPublicExponent(), rSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof aVL && privateKey instanceof aVL) {
            if (!((aVL)((Object)publicKey)).bpR().equals(((aVL)((Object)privateKey)).bpR())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof aVN && privateKey instanceof aVM) {
                aVM aVM2 = (aVM)privateKey;
                aVN aVN2 = (aVN)publicKey;
                aYT aYT2 = aVM2.bpR();
                aYS aYS2 = (aYS)aYT2.getDomainParametersSpec();
                if (aYS2.getA().modPow(aVM2.getX(), aYS2.getP()).equals(aVN2.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof aVJ) || !(privateKey instanceof aVI)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            aVI aVI2 = (aVI)privateKey;
            aVJ aVJ2 = (aVJ)publicKey;
            aYT aYT3 = aVI2.bpR();
            aYK aYK3 = (aYK)aYT3.getDomainParametersSpec();
            aYK aYK4 = new aYK(aYK3);
            if (aYK4.bkn().bib().i(aVI2.getS()).brE().h(aYK4.bkn().bia().l(aVJ2.getW().getAffineX(), aVJ2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (publicKey instanceof aVF && privateKey instanceof aVF) {
            aVG aVG2 = (aVG)privateKey;
            aVH aVH2 = (aVH)publicKey;
            if (!aVG2.bpQ().equals(aVH2.bpQ())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            aYH aYH2 = aVG2.bpQ();
            aYK aYK5 = new aYK(aYH2);
            if (aYK5.bkn().bib().i(aVG2.getS()).brF().brE().h(aYK5.bkn().bia().l(aVH2.getW().getAffineX(), aVH2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (publicKey instanceof aVK && privateKey instanceof aVK) {
            aVK aVK2 = (aVK)((Object)privateKey);
            aVK aVK3 = (aVK)((Object)publicKey);
            if (!aVK2.getAlgorithm().equals(aVK3.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (bgx.areEqual(aVK2.getPublicData(), aVK3.getPublicData())) return;
            throw new IllegalArgumentException("EdDSA public key not consistent with EdDSA private key");
        }
        if (!(publicKey instanceof aVO) || !(privateKey instanceof aVO)) throw new IllegalArgumentException("Key pair inconsistent");
        aVO aVO2 = (aVO)((Object)privateKey);
        aVO aVO3 = (aVO)((Object)publicKey);
        if (!aVO2.getAlgorithm().equals(aVO3.getAlgorithm())) {
            throw new IllegalArgumentException("XDH keys do not have the same domain parameters");
        }
        if (bgx.areEqual(aVO2.getPublicData(), aVO3.getPublicData())) return;
        throw new IllegalArgumentException("XDH public key not consistent with XDH private key");
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }
}

