/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aQZ;
import com.aspose.html.utils.aRe;
import com.aspose.html.utils.aRh;
import com.aspose.html.utils.aRo;
import com.aspose.html.utils.aRw;
import com.aspose.html.utils.aSD;
import com.aspose.html.utils.aSe;
import com.aspose.html.utils.aSr;
import com.aspose.html.utils.aSs;
import com.aspose.html.utils.aSt;
import com.aspose.html.utils.aSu;
import com.aspose.html.utils.aSv;
import com.aspose.html.utils.aTi;
import com.aspose.html.utils.aTm;
import com.aspose.html.utils.bgI;
import com.aspose.html.utils.bgx;

public class aSk
implements aSe {
    private static final int lqT = 16;
    private aQZ lbN;
    private aSs lqU;
    private aSr lqV;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private byte[] H;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] S_at;
    private byte[] S_atPre;
    private byte[] counter;
    private int blocksRemaining;
    private int bufOff;
    private long totalLength;
    private byte[] atBlock;
    private int atBlockPos;
    private long atLength;
    private long atLengthPre;

    public aSk(aQZ aQZ2) {
        this(aQZ2, null);
    }

    public aSk(aQZ aQZ2, aSs aSs2) {
        if (aQZ2.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (aSs2 == null) {
            aSs2 = new aSv();
        }
        this.lbN = aQZ2;
        this.lqU = aSs2;
    }

    public aQZ bor() {
        return this.lbN;
    }

    public String getAlgorithmName() {
        return this.lbN.getAlgorithmName() + "/GCM";
    }

    public void a(boolean bl2, aRe aRe2) throws IllegalArgumentException {
        aTi aTi2;
        aRe aRe3;
        this.forEncryption = bl2;
        this.macBlock = null;
        if (aRe2 instanceof aSD) {
            aRe3 = (aSD)aRe2;
            this.nonce = ((aSD)aRe3).getNonce();
            this.initialAssociatedText = ((aSD)aRe3).getAssociatedText();
            int n2 = ((aSD)aRe3).getMacSize();
            if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.macSize = n2 / 8;
            aTi2 = ((aSD)aRe3).bov();
        } else if (aRe2 instanceof aTm) {
            aRe3 = (aTm)aRe2;
            this.nonce = ((aTm)aRe3).getIV();
            this.initialAssociatedText = null;
            this.macSize = 16;
            aTi2 = (aTi)((aTm)aRe3).boK();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = bl2 ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[n3];
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (aTi2 != null) {
            this.lbN.a(true, aTi2);
            this.H = new byte[16];
            this.lbN.processBlock(this.H, 0, this.H, 0);
            this.lqU.init(this.H);
            this.lqV = null;
        } else if (this.H == null) {
            throw new IllegalArgumentException("Key must be specified in initial init");
        }
        this.J0 = new byte[16];
        if (this.nonce.length == 12) {
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            this.gHASH(this.J0, this.nonce, this.nonce.length);
            byte[] byArray = new byte[16];
            bgI.longToBigEndian((long)this.nonce.length * 8L, byArray, 8);
            this.gHASHBlock(this.J0, byArray);
        }
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = bgx.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public byte[] getMac() {
        return bgx.clone(this.macBlock);
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % 16;
    }

    public void processAADByte(byte by2) {
        this.atBlock[this.atBlockPos] = by2;
        if (++this.atBlockPos == 16) {
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.atBlock[this.atBlockPos] = byArray[n2 + i2];
            if (++this.atBlockPos != 16) continue;
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    private void initCipher() {
        if (this.atLength > 0L) {
            System.arraycopy(this.S_at, 0, this.S_atPre, 0, 16);
            this.atLengthPre = this.atLength;
        }
        if (this.atBlockPos > 0) {
            this.gHASHPartial(this.S_atPre, this.atBlock, 0, this.atBlockPos);
            this.atLengthPre += (long)this.atBlockPos;
        }
        if (this.atLengthPre > 0L) {
            System.arraycopy(this.S_atPre, 0, this.S, 0, 16);
        }
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws aRh {
        this.bufBlock[this.bufOff] = by2;
        if (++this.bufOff == this.bufBlock.length) {
            this.outputBlock(byArray, n2);
            return 16;
        }
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws aRh {
        if (byArray.length < n2 + n3) {
            throw new aRh("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bufBlock[this.bufOff] = byArray[n2 + i2];
            if (++this.bufOff != this.bufBlock.length) continue;
            this.outputBlock(byArray2, n4 + n5);
            n5 += 16;
        }
        return n5;
    }

    private void outputBlock(byte[] byArray, int n2) {
        if (byArray.length < n2 + 16) {
            throw new aRw("Output buffer too short");
        }
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        this.gCTRBlock(this.bufBlock, byArray, n2);
        if (this.forEncryption) {
            this.bufOff = 0;
        } else {
            System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
            this.bufOff = this.macSize;
        }
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, aRo {
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        int n3 = this.bufOff;
        if (this.forEncryption) {
            if (byArray.length < n2 + n3 + this.macSize) {
                throw new aRw("Output buffer too short");
            }
        } else {
            if (n3 < this.macSize) {
                throw new aRo("data too short");
            }
            if (byArray.length < n2 + (n3 -= this.macSize)) {
                throw new aRw("Output buffer too short");
            }
        }
        if (n3 > 0) {
            this.gCTRPartial(this.bufBlock, 0, n3, byArray, n2);
        }
        this.atLength += (long)this.atBlockPos;
        if (this.atLength > this.atLengthPre) {
            if (this.atBlockPos > 0) {
                this.gHASHPartial(this.S_at, this.atBlock, 0, this.atBlockPos);
            }
            if (this.atLengthPre > 0L) {
                aSt.xor(this.S_at, this.S_atPre);
            }
            long l2 = this.totalLength * 8L + 127L >>> 7;
            byte[] byArray2 = new byte[16];
            if (this.lqV == null) {
                this.lqV = new aSu();
                this.lqV.init(this.H);
            }
            this.lqV.exponentiateX(l2, byArray2);
            aSt.multiply(this.S_at, byArray2);
            aSt.xor(this.S, this.S_at);
        }
        byte[] byArray3 = new byte[16];
        bgI.longToBigEndian(this.atLength * 8L, byArray3, 0);
        bgI.longToBigEndian(this.totalLength * 8L, byArray3, 8);
        this.gHASHBlock(this.S, byArray3);
        byte[] byArray4 = new byte[16];
        this.lbN.processBlock(this.J0, 0, byArray4, 0);
        aSt.xor(byArray4, this.S);
        int n4 = n3;
        this.macBlock = new byte[this.macSize];
        System.arraycopy(byArray4, 0, this.macBlock, 0, this.macSize);
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, byArray, n2 + this.bufOff, this.macSize);
            n4 += this.macSize;
        } else {
            byte[] byArray5 = new byte[this.macSize];
            System.arraycopy(this.bufBlock, n3, byArray5, 0, this.macSize);
            if (!bgx.constantTimeAreEqual(this.macBlock, byArray5)) {
                throw new aRo("mac check in GCM failed");
            }
        }
        this.reset(false);
        return n4;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.lbN.reset();
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = bgx.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            bgx.fill(this.bufBlock, (byte)0);
        }
        if (bl2) {
            this.macBlock = null;
        }
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private void gCTRBlock(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.getNextCounterBlock();
        aSt.xor(byArray3, byArray);
        System.arraycopy(byArray3, 0, byArray2, n2, 16);
        this.gHASHBlock(this.S, this.forEncryption ? byArray3 : byArray);
        this.totalLength += 16L;
    }

    private void gCTRPartial(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = this.getNextCounterBlock();
        aSt.xor(byArray3, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, n3);
        this.gHASHPartial(this.S, this.forEncryption ? byArray3 : byArray, 0, n3);
        this.totalLength += (long)n3;
    }

    private void gHASH(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.gHASHPartial(byArray, byArray2, i2, n3);
        }
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2) {
        aSt.xor(byArray, byArray2);
        this.lqU.multiplyH(byArray);
    }

    private void gHASHPartial(byte[] byArray, byte[] byArray2, int n2, int n3) {
        aSt.xor(byArray, byArray2, n2, n3);
        this.lqU.multiplyH(byArray);
    }

    private byte[] getNextCounterBlock() {
        if (this.blocksRemaining == 0) {
            throw new IllegalStateException("Attempt to process too many blocks in GCM");
        }
        --this.blocksRemaining;
        int n2 = 1;
        this.counter[15] = (byte)(n2 += this.counter[15] & 0xFF);
        n2 >>>= 8;
        this.counter[14] = (byte)(n2 += this.counter[14] & 0xFF);
        n2 >>>= 8;
        this.counter[13] = (byte)(n2 += this.counter[13] & 0xFF);
        n2 >>>= 8;
        this.counter[12] = (byte)(n2 += this.counter[12] & 0xFF);
        byte[] byArray = new byte[16];
        this.lbN.processBlock(this.counter, 0, byArray, 0);
        return byArray;
    }
}

