/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aQZ;
import com.aspose.html.utils.aRZ;
import com.aspose.html.utils.aRe;
import com.aspose.html.utils.aRh;
import com.aspose.html.utils.aRo;
import com.aspose.html.utils.aRt;
import com.aspose.html.utils.aRw;
import com.aspose.html.utils.aSD;
import com.aspose.html.utils.aSe;
import com.aspose.html.utils.aSq;
import com.aspose.html.utils.aTm;
import com.aspose.html.utils.bgx;

public class aSi
implements aSe {
    private static final byte lqM = 0;
    private static final byte lqN = 1;
    private static final byte lqO = 2;
    private aSq lqP;
    private boolean forEncryption;
    private int blockSize;
    private aRt lqq;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public aSi(aQZ aQZ2) {
        this.blockSize = aQZ2.getBlockSize();
        this.lqq = new aRZ(aQZ2);
        this.macBlock = new byte[this.blockSize];
        this.associatedTextMac = new byte[this.lqq.getMacSize()];
        this.nonceMac = new byte[this.lqq.getMacSize()];
        this.lqP = new aSq(aQZ2);
    }

    public String getAlgorithmName() {
        return this.lqP.bor().getAlgorithmName() + "/EAX";
    }

    public aQZ bor() {
        return this.lqP.bor();
    }

    public int getBlockSize() {
        return this.lqP.getBlockSize();
    }

    public void a(boolean bl2, aRe aRe2) throws IllegalArgumentException {
        aRe aRe3;
        byte[] byArray;
        Object object;
        this.forEncryption = bl2;
        if (aRe2 instanceof aSD) {
            object = (aSD)aRe2;
            byArray = ((aSD)object).getNonce();
            this.initialAssociatedText = ((aSD)object).getAssociatedText();
            this.macSize = ((aSD)object).getMacSize() / 8;
            aRe3 = ((aSD)object).bov();
        } else if (aRe2 instanceof aTm) {
            object = (aTm)aRe2;
            byArray = ((aTm)object).getIV();
            this.initialAssociatedText = null;
            this.macSize = this.lqq.getMacSize() / 2;
            aRe3 = ((aTm)object).boK();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.bufBlock = new byte[bl2 ? this.blockSize : this.blockSize + this.macSize];
        object = new byte[this.blockSize];
        this.lqq.a(aRe3);
        object[this.blockSize - 1] = false;
        this.lqq.update((byte[])object, 0, this.blockSize);
        this.lqq.update(byArray, 0, byArray.length);
        this.lqq.doFinal(this.nonceMac, 0);
        this.lqP.a(true, new aTm(null, this.nonceMac));
        this.reset();
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        this.cipherInitialized = true;
        this.lqq.doFinal(this.associatedTextMac, 0);
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 2;
        this.lqq.update(byArray, 0, this.blockSize);
    }

    private void calculateMac() {
        byte[] byArray = new byte[this.blockSize];
        this.lqq.doFinal(byArray, 0);
        for (int i2 = 0; i2 < this.macBlock.length; ++i2) {
            this.macBlock[i2] = (byte)(this.nonceMac[i2] ^ this.associatedTextMac[i2] ^ byArray[i2]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.lqP.reset();
        this.lqq.reset();
        this.bufOff = 0;
        bgx.fill(this.bufBlock, (byte)0);
        if (bl2) {
            bgx.fill(this.macBlock, (byte)0);
        }
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 1;
        this.lqq.update(byArray, 0, this.blockSize);
        this.cipherInitialized = false;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public void processAADByte(byte by2) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decription processing has begun.");
        }
        this.lqq.update(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.lqq.update(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws aRh {
        this.initCipher();
        return this.process(by2, byArray, n2);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws aRh {
        this.initCipher();
        if (byArray.length < n2 + n3) {
            throw new aRh("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 != n3; ++i2) {
            n5 += this.process(byArray[n2 + i2], byArray2, n4 + n5);
        }
        return n5;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, aRo {
        this.initCipher();
        int n3 = this.bufOff;
        byte[] byArray2 = new byte[this.bufBlock.length];
        this.bufOff = 0;
        if (this.forEncryption) {
            if (byArray.length < n2 + n3 + this.macSize) {
                throw new aRw("Output buffer too short");
            }
            this.lqP.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            this.lqq.update(byArray2, 0, n3);
            this.calculateMac();
            System.arraycopy(this.macBlock, 0, byArray, n2 + n3, this.macSize);
            this.reset(false);
            return n3 + this.macSize;
        }
        if (byArray.length < n2 + n3 - this.macSize) {
            throw new aRw("Output buffer too short");
        }
        if (n3 < this.macSize) {
            throw new aRo("data too short");
        }
        if (n3 > this.macSize) {
            this.lqq.update(this.bufBlock, 0, n3 - this.macSize);
            this.lqP.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3 - this.macSize);
        }
        this.calculateMac();
        if (!this.verifyMac(this.bufBlock, n3 - this.macSize)) {
            throw new aRo("mac check in EAX failed");
        }
        this.reset(false);
        return n3 - this.macSize;
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, this.macSize);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % this.blockSize;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    private int process(byte by2, byte[] byArray, int n2) {
        this.bufBlock[this.bufOff++] = by2;
        if (this.bufOff == this.bufBlock.length) {
            int n3;
            if (byArray.length < n2 + this.blockSize) {
                throw new aRw("Output buffer is too short");
            }
            if (this.forEncryption) {
                n3 = this.lqP.processBlock(this.bufBlock, 0, byArray, n2);
                this.lqq.update(byArray, n2, this.blockSize);
            } else {
                this.lqq.update(this.bufBlock, 0, this.blockSize);
                n3 = this.lqP.processBlock(this.bufBlock, 0, byArray, n2);
            }
            this.bufOff = 0;
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, this.blockSize, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
            }
            return n3;
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.macSize; ++i2) {
            n3 |= this.macBlock[i2] ^ byArray[n2 + i2];
        }
        return n3 == 0;
    }
}

