/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aQZ;
import com.aspose.html.utils.aRX;
import com.aspose.html.utils.aRe;
import com.aspose.html.utils.aRh;
import com.aspose.html.utils.aRo;
import com.aspose.html.utils.aRw;
import com.aspose.html.utils.aSD;
import com.aspose.html.utils.aSe;
import com.aspose.html.utils.aSq;
import com.aspose.html.utils.aTm;
import com.aspose.html.utils.bgx;
import java.io.ByteArrayOutputStream;

public class aSg
implements aSe {
    private aQZ lbN;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private aRe lqJ;
    private byte[] macBlock;
    private a lqK = new a();
    private a lqL = new a();

    public aSg(aQZ aQZ2) {
        this.lbN = aQZ2;
        this.blockSize = aQZ2.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public aQZ bor() {
        return this.lbN;
    }

    public void a(boolean bl2, aRe aRe2) throws IllegalArgumentException {
        aRe aRe3;
        this.forEncryption = bl2;
        if (aRe2 instanceof aSD) {
            aSD aSD2 = (aSD)aRe2;
            this.nonce = aSD2.getNonce();
            this.initialAssociatedText = aSD2.getAssociatedText();
            this.macSize = aSD2.getMacSize() / 8;
            aRe3 = aSD2.bov();
        } else if (aRe2 instanceof aTm) {
            aTm aTm2 = (aTm)aRe2;
            this.nonce = aTm2.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            aRe3 = aTm2.boK();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (aRe3 != null) {
            this.lqJ = aRe3;
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.lbN.getAlgorithmName() + "/CCM";
    }

    public void processAADByte(byte by2) {
        this.lqK.write(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.lqK.write(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws aRh, IllegalStateException {
        this.lqL.write(by2);
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws aRh, IllegalStateException {
        if (byArray.length < n2 + n3) {
            throw new aRh("Input buffer too short");
        }
        this.lqL.write(byArray, n2, n3);
        return 0;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, aRo {
        int n3 = this.processPacket(this.lqL.getBuffer(), 0, this.lqL.size(), byArray, n2);
        this.reset();
        return n3;
    }

    public void reset() {
        this.lbN.reset();
        this.lqK.reset();
        this.lqL.reset();
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        return 0;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.lqL.size();
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int processPacket(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, aRo, aRh {
        int n5;
        int n6;
        int n7;
        if (this.lqJ == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n8 = this.nonce.length;
        int n9 = 15 - n8;
        if (n9 < 4 && n3 >= (n7 = 1 << 8 * n9)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray3 = new byte[this.blockSize];
        byArray3[0] = (byte)(n9 - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        aSq aSq2 = new aSq(this.lbN);
        aSq2.a(this.forEncryption, new aTm(this.lqJ, byArray3));
        int n10 = n4;
        if (this.forEncryption) {
            n6 = n3 + this.macSize;
            if (byArray2.length < n6 + n4) {
                throw new aRw("Output buffer too short.");
            }
            this.calculateMac(byArray, n2, n3, this.macBlock);
            byte[] byArray4 = new byte[this.blockSize];
            aSq2.processBlock(this.macBlock, 0, byArray4, 0);
            for (n5 = n2; n5 < n2 + n3 - this.blockSize; n5 += this.blockSize) {
                aSq2.processBlock(byArray, n5, byArray2, n10);
                n10 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n5, byArray5, 0, n3 + n2 - n5);
            aSq2.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n10, n3 + n2 - n5);
            System.arraycopy(byArray4, 0, byArray2, n4 + n3, this.macSize);
        } else {
            if (n3 < this.macSize) {
                throw new aRo("data too short");
            }
            n6 = n3 - this.macSize;
            if (byArray2.length < n6 + n4) {
                throw new aRw("Output buffer too short.");
            }
            System.arraycopy(byArray, n2 + n6, this.macBlock, 0, this.macSize);
            aSq2.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i2 = this.macSize; i2 != this.macBlock.length; ++i2) {
                this.macBlock[i2] = 0;
            }
            while (n5 < n2 + n6 - this.blockSize) {
                aSq2.processBlock(byArray, n5, byArray2, n10);
                n10 += this.blockSize;
                n5 += this.blockSize;
            }
            byte[] byArray6 = new byte[this.blockSize];
            System.arraycopy(byArray, n5, byArray6, 0, n6 - (n5 - n2));
            aSq2.processBlock(byArray6, 0, byArray6, 0);
            System.arraycopy(byArray6, 0, byArray2, n10, n6 - (n5 - n2));
            byte[] byArray7 = new byte[this.blockSize];
            this.calculateMac(byArray2, n4, n6, byArray7);
            if (!bgx.constantTimeAreEqual(this.macBlock, byArray7)) {
                throw new aRo("mac check in CCM failed");
            }
        }
        return n6;
    }

    private int calculateMac(byte[] byArray, int n2, int n3, byte[] byArray2) {
        aRX aRX2 = new aRX(this.lbN, this.macSize * 8);
        aRX2.a(this.lqJ);
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((aRX2.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        int n4 = n3;
        int n5 = 1;
        while (n4 > 0) {
            byArray3[byArray3.length - n5] = (byte)(n4 & 0xFF);
            n4 >>>= 8;
            ++n5;
        }
        aRX2.update(byArray3, 0, byArray3.length);
        if (this.hasAssociatedText()) {
            int n6;
            int n7 = this.getAssociatedTextLength();
            if (n7 < 65280) {
                aRX2.update((byte)(n7 >> 8));
                aRX2.update((byte)n7);
                n6 = 2;
            } else {
                aRX2.update((byte)-1);
                aRX2.update((byte)-2);
                aRX2.update((byte)(n7 >> 24));
                aRX2.update((byte)(n7 >> 16));
                aRX2.update((byte)(n7 >> 8));
                aRX2.update((byte)n7);
                n6 = 6;
            }
            if (this.initialAssociatedText != null) {
                aRX2.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.lqK.size() > 0) {
                aRX2.update(this.lqK.getBuffer(), 0, this.lqK.size());
            }
            if ((n6 = (n6 + n7) % 16) != 0) {
                for (int i2 = n6; i2 != 16; ++i2) {
                    aRX2.update((byte)0);
                }
            }
        }
        aRX2.update(byArray, n2, n3);
        return aRX2.doFinal(byArray2, 0);
    }

    private int getAssociatedTextLength() {
        return this.lqK.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }

    static class a
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

