/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aOy;
import com.aspose.html.utils.aQZ;
import com.aspose.html.utils.aRe;
import com.aspose.html.utils.aRt;
import com.aspose.html.utils.aSf;
import com.aspose.html.utils.aSw;
import com.aspose.html.utils.aTi;
import com.aspose.html.utils.aTj;
import com.aspose.html.utils.aTm;

class aPM
implements aRt {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private aQZ lbN;
    private aSw ldJ;
    private int macSize;
    private aTi ldK;
    private aTi ldL;

    public aPM(aQZ aQZ2) {
        this(aQZ2, aQZ2.getBlockSize() * 8, null);
    }

    public aPM(aQZ aQZ2, aSw aSw2) {
        this(aQZ2, aQZ2.getBlockSize() * 8, aSw2);
    }

    public aPM(aQZ aQZ2, int n2) {
        this(aQZ2, n2, null);
    }

    public aPM(aQZ aQZ2, int n2, aSw aSw2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!aQZ2.getAlgorithmName().startsWith("DES")) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.lbN = new aSf(aQZ2);
        this.ldJ = aSw2;
        this.macSize = n2 / 8;
        this.mac = new byte[aQZ2.getBlockSize()];
        this.buf = new byte[aQZ2.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    public void a(aRe aRe2) {
        aTj aTj2;
        this.reset();
        if (!(aRe2 instanceof aTi) && !(aRe2 instanceof aTm)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        aTi aTi2 = aRe2 instanceof aTi ? (aTi)aRe2 : (aTi)((aTm)aRe2).boK();
        byte[] byArray = aTi2.getKey();
        if (byArray.length == 16) {
            aTj2 = new aTj(byArray, 0, 8);
            this.ldK = new aTj(byArray, 8, 8);
            this.ldL = aTj2;
        } else if (byArray.length == 24) {
            aTj2 = new aTj(byArray, 0, 8);
            this.ldK = new aTj(byArray, 8, 8);
            this.ldL = new aTj(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (aRe2 instanceof aTm) {
            this.lbN.a(true, new aTm(aTj2, ((aTm)aRe2).getIV()));
        } else {
            this.lbN.a(true, aTj2);
        }
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            this.lbN.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.lbN.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.bufOff;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n6);
            n5 += this.lbN.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.lbN.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.lbN.getBlockSize();
        if (this.ldJ == null) {
            while (this.bufOff < n3) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            if (this.bufOff == n3) {
                this.lbN.processBlock(this.buf, 0, this.mac, 0);
                this.bufOff = 0;
            }
            this.ldJ.addPadding(this.buf, this.bufOff);
        }
        this.lbN.processBlock(this.buf, 0, this.mac, 0);
        aOy aOy2 = new aOy();
        aOy2.a(false, this.ldK);
        aOy2.processBlock(this.mac, 0, this.mac, 0);
        aOy2.a(true, this.ldL);
        aOy2.processBlock(this.mac, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.lbN.reset();
    }
}

