/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aJD;
import com.aspose.html.utils.aLK;
import com.aspose.html.utils.aMo;
import com.aspose.html.utils.aNR;
import com.aspose.html.utils.aNW;
import com.aspose.html.utils.aRk;
import com.aspose.html.utils.bgE;
import com.aspose.html.utils.bgY;
import com.aspose.html.utils.bgx;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

class aNn
implements aNR {
    private static final byte[] kQX = new byte[]{0};
    private static final byte[] kQY = new byte[]{1};
    private static final long kQZ = 0x800000000000L;
    private static final int kRa = 262144;
    private static final Hashtable kRb = new Hashtable();
    private static final Map<String, byte[][]> kRc = new HashMap<String, byte[][]>();
    private static final Map<String, byte[]> kRd = new HashMap<String, byte[]>();
    private static final Map<String, byte[][]> kRe = new HashMap<String, byte[][]>();
    private aRk kFD;
    private byte[] _V;
    private byte[] _C;
    private long _reseedCounter;
    private aJD kBn;
    private int _securityStrength;
    private int _seedLength;

    public aNn(aRk aRk2, int n2, aJD aJD2, byte[] byArray, byte[] byArray2) {
        this.a(aRk2, n2, aJD2, byArray, byArray2);
    }

    private void a(aRk aRk2, int n2, aJD aJD2, byte[] byArray, byte[] byArray2) {
        if (n2 > aLK.b(aRk2)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (aJD2.entropySize() < n2) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this.kFD = aRk2;
        this.kBn = aJD2;
        this._securityStrength = n2;
        this._seedLength = (Integer)kRb.get(aRk2.getAlgorithmName());
        byte[] byArray3 = this.getEntropy();
        byte[] byArray4 = bgx.concatenate(byArray3, byArray2, byArray);
        bgx.fill(byArray3, (byte)0);
        this.reseedFromSeedMaterial(byArray4);
    }

    public int getBlockSize() {
        return this.kFD.getDigestSize() * 8;
    }

    public int getSecurityStrength() {
        return this._securityStrength;
    }

    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        byte[] byArray3;
        byte[] byArray4;
        int n2 = byArray.length * 8;
        if (n2 > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (bl2) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (this._reseedCounter > 0x800000000000L) {
            return -1;
        }
        if (byArray2 != null) {
            byArray4 = new byte[1 + this._V.length + byArray2.length];
            byArray4[0] = 2;
            System.arraycopy(this._V, 0, byArray4, 1, this._V.length);
            System.arraycopy(byArray2, 0, byArray4, 1 + this._V.length, byArray2.length);
            byArray3 = this.hash(byArray4);
            this.addTo(this._V, byArray3);
        }
        byArray4 = this.hashgen(this._V, n2);
        byArray3 = new byte[this._V.length + 1];
        System.arraycopy(this._V, 0, byArray3, 1, this._V.length);
        byArray3[0] = 3;
        byte[] byArray5 = this.hash(byArray3);
        this.addTo(this._V, byArray5);
        this.addTo(this._V, this._C);
        byte[] byArray6 = new byte[]{(byte)(this._reseedCounter >> 24), (byte)(this._reseedCounter >> 16), (byte)(this._reseedCounter >> 8), (byte)this._reseedCounter};
        this.addTo(this._V, byArray6);
        ++this._reseedCounter;
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
        return n2;
    }

    private void addTo(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 1; n3 <= byArray2.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + (byArray2[byArray2.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
        for (n3 = byArray2.length + 1; n3 <= byArray.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
    }

    public void reseed(byte[] byArray) {
        byte[] byArray2 = this.getEntropy();
        byte[] byArray3 = bgx.concatenate(kQY, this._V, byArray2, byArray);
        bgx.fill(byArray2, (byte)0);
        this.reseedFromSeedMaterial(byArray3);
    }

    private void reseedFromSeedMaterial(byte[] byArray) {
        this._V = this.hashSeedMaterial(byArray);
        this._C = this.hashSeedMaterial(bgx.concatenate(kQX, this._V));
        this._reseedCounter = 1L;
    }

    private byte[] hashSeedMaterial(byte[] byArray) {
        try {
            byte[] byArray2 = aLK.a(this.kFD, byArray, this._seedLength);
            return byArray2;
        }
        finally {
            bgx.fill(byArray, (byte)0);
        }
    }

    private byte[] getEntropy() {
        byte[] byArray = this.kBn.getEntropy();
        if (byArray == null || byArray.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        bgx.fill(this._V, (byte)0);
        bgx.fill(this._C, (byte)0);
    }

    public aNW a(aMo aMo2) {
        return new aNW(aMo2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] byArray = aNn.this._V;
                byte[] byArray2 = aNn.this._C;
                long l2 = aNn.this._reseedCounter;
                aJD aJD2 = aNn.this.kBn;
                int n2 = aNn.this._seedLength;
                int n3 = aNn.this._securityStrength;
                try {
                    int n4;
                    byte[] byArray3;
                    byte[] byArray4;
                    block16: {
                        block15: {
                            block14: {
                                byArray4 = bgY.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                byArray3 = bgY.decode("2021222324");
                                n4 = aLK.b(aNn.this.kFD);
                                byte[][] byArray5 = (byte[][])kRc.get(this.kTl.getName());
                                aNn.this.a(aNn.this.kFD, aNn.this._securityStrength, new aLK.a().ma(n4), byArray4, byArray3);
                                byte[] byArray6 = new byte[byArray5[0].length];
                                aNn.this.generate(byArray6, null, true);
                                if (!bgx.areEqual(byArray5[0], byArray6)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                byArray6 = new byte[byArray5[1].length];
                                aNn.this.generate(byArray6, null, true);
                                if (!bgx.areEqual(byArray5[1], byArray6)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    aNn.this.a(aNn.this.kFD, aNn.this._securityStrength, new aLK.b(n4), byArray4, byArray3);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                aNn.this.a(aNn.this.kFD, aNn.this._securityStrength, new aLK.b(20), byArray4, byArray3);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (illegalArgumentException.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            aNn.this.kBn = new aLK.b(n4);
                            aNn.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        aNn.this.a(aNn.this.kFD, n4 + 1, new aLK.a().ma(n4), byArray4, byArray3);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!illegalArgumentException.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    aNn.a(aNn.this, byArray);
                    aNn.b(aNn.this, byArray2);
                    aNn.this._reseedCounter = l2;
                    aNn.this.kBn = aJD2;
                    aNn.this._seedLength = n2;
                    aNn.this._securityStrength = n3;
                }
            }
        };
    }

    public aNW b(aMo aMo2) {
        return new aNW(aMo2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] byArray = aNn.this._V;
                byte[] byArray2 = aNn.this._C;
                long l2 = aNn.this._reseedCounter;
                aJD aJD2 = aNn.this.kBn;
                int n2 = aNn.this._seedLength;
                int n3 = aNn.this._securityStrength;
                try {
                    byte[] byArray3 = bgY.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int n4 = aLK.b(aNn.this.kFD);
                    byte[][] byArray4 = (byte[][])kRe.get(this.kTl.getName());
                    aNn.a(aNn.this, bgx.clone((byte[])kRd.get(this.kTl.getName())));
                    aNn.this.kBn = new aLK.a().ma(n4);
                    aNn.this.reseed(byArray3);
                    if (aNn.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byte[] byArray5 = new byte[byArray4[0].length];
                    aNn.this.generate(byArray5, null, false);
                    if (!bgx.areEqual(byArray4[0], byArray5)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    byArray5 = new byte[byArray4[1].length];
                    aNn.this.generate(byArray5, null, false);
                    if (!bgx.areEqual(byArray4[1], byArray5)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        aNn.this.kBn = new aLK.b(n4);
                        aNn.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected on reseed");
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    aNn.a(aNn.this, byArray);
                    aNn.b(aNn.this, byArray2);
                    aNn.this._reseedCounter = l2;
                    aNn.this.kBn = aJD2;
                    aNn.this._seedLength = n2;
                    aNn.this._securityStrength = n3;
                }
            }
        };
    }

    private byte[] hash(byte[] byArray) {
        byte[] byArray2 = new byte[this.kFD.getDigestSize()];
        this.doHash(byArray, byArray2);
        return byArray2;
    }

    private void doHash(byte[] byArray, byte[] byArray2) {
        this.kFD.update(byArray, 0, byArray.length);
        this.kFD.doFinal(byArray2, 0);
    }

    private byte[] hashgen(byte[] byArray, int n2) {
        int n3 = this.kFD.getDigestSize();
        int n4 = n2 / 8 / n3;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[n2 / 8];
        byte[] byArray4 = new byte[this.kFD.getDigestSize()];
        for (int i2 = 0; i2 <= n4; ++i2) {
            this.doHash(byArray2, byArray4);
            int n5 = byArray3.length - i2 * byArray4.length > byArray4.length ? byArray4.length : byArray3.length - i2 * byArray4.length;
            System.arraycopy(byArray4, 0, byArray3, i2 * byArray4.length, n5);
            this.addTo(byArray2, kQY);
        }
        return byArray3;
    }

    static /* synthetic */ byte[] a(aNn aNn2, byte[] byArray) {
        aNn2._V = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] b(aNn aNn2, byte[] byArray) {
        aNn2._C = byArray;
        return byArray;
    }

    static {
        kRb.put("SHA-1", bgE.valueOf(440));
        kRb.put("SHA-224", bgE.valueOf(440));
        kRb.put("SHA-256", bgE.valueOf(440));
        kRb.put("SHA-512/256", bgE.valueOf(440));
        kRb.put("SHA-512/224", bgE.valueOf(440));
        kRb.put("SHA-384", bgE.valueOf(888));
        kRb.put("SHA-512", bgE.valueOf(888));
        kRc.put("SHA-1", new byte[][]{bgY.decode("61a50e3970bdb72c7ebf2a6225519ea2f324148123a3503443ec80993a62c4ea6528ff4f5f4fe778"), bgY.decode("71adf1e44be3e0a6af022d6e79aad42a99d8261ef41e06c3efed4ac8bf9687e8e1bab92da552e109")});
        kRc.put("SHA-224", new byte[][]{bgY.decode("5be6d688ee42f489506a5a3407380325c633627f8c2458c1d82fc9a3db5787565c9d6c5e0e32b5f0"), bgY.decode("3726e8c434f91c2fdd6d80621e79005f38320932ca9da5edad095eeff18693b7908f936268e20b58")});
        kRc.put("SHA-256", new byte[][]{bgY.decode("788dd696649d97295de7ed10a2c55104abb36cd0f262abdc2b8b2b183a3602c3f7513d2a4893b759"), bgY.decode("3db6a852f92035e4890fa53438cf8070020a95ae19f1098f98a4d4bdb65f3c5c2dd4c9fb5483410d")});
        kRc.put("SHA-384", new byte[][]{bgY.decode("0536f72f4123b8e438981912b3c60b09d1303a93b7cbe4af13cd3ae01d389720ff687916135bb254"), bgY.decode("80ae6b3d1a120d9f58d427a178c7d73d429758f6039962b66f8afbc7fa758228b13b8f5829588cd6")});
        kRc.put("SHA-512", new byte[][]{bgY.decode("ca8387ba70bc7f8cb71e5d25703972ed58c7b5c81649050cdc17a9f646f7bd57857ca715e411d2ca"), bgY.decode("ce2fe5ba54cde888bee0f4863ca70b258ab6e2be31523542a4da66033433fb8e7e394b28198daa1e")});
        kRc.put("SHA-512(224)", new byte[][]{bgY.decode("d2a49d96a75e30d65da621aaf5e3e84b1c3d5313aefa2d276c9e1d836615217b67d766ccd342e956"), bgY.decode("32195006d69ed3cdef3d6e5af94ae91c0c3282202b0bfebdc11cc9d4c02f534b0f6bb9a8b8f2b7fe")});
        kRc.put("SHA-512(256)", new byte[][]{bgY.decode("881b2a06f0f23921341819bf9cf78ed122850a80ae6c6eaf84e84600d756486c442305a495db0d96"), bgY.decode("c9351dfad36fd8309a5bd598ac4ee9ca22297263f21c21d8481acefea97f5e508134f43959ac7f90")});
        kRd.put("SHA-1", bgY.decode("3c01bdbb26f358bab27f267924aa2c9a03fcfdb8"));
        kRd.put("SHA-224", bgY.decode("107c5072b799c4771f328304cfe1ebb375eb6ea7f35a3aa753836fad"));
        kRd.put("SHA-256", bgY.decode("b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78"));
        kRd.put("SHA-384", bgY.decode("1e02dc92a41db610c9bcdc9b5935d1fb9be5639116f6c67e97bc1a3ac649753baba7ba021c813e1fe20c0480213ad371"));
        kRd.put("SHA-512", bgY.decode("397118fdac8d83ad98813c50759c85b8c47565d8268bf10da483153b747a74743a58a90e85aa9f705ce6984ffc128db567489817e4092d050d8a1cc596ddc119"));
        kRd.put("SHA-512(224)", bgY.decode("2a2aa10c3ca33a979d6cc7d36f94425fb72a09d3d7137c8b9b5b4474"));
        kRd.put("SHA-512(256)", bgY.decode("625c3e642852cb343b9b06eae14b47a7da0fd292a7be7b8a251208a65271af36"));
        kRe.put("SHA-1", new byte[][]{bgY.decode("657d09ba244bf82e69ee1f860d9bfbf53aebd25827aab770e1f33d4d7bd34596d5f1be2ff0dcde4c"), bgY.decode("01b3e73d42c180963004e6d4d31f38f1bfa3a815c8571f4d9bbed56d5f8afc8f1da145d36232554f")});
        kRe.put("SHA-224", new byte[][]{bgY.decode("267c1bc6462b4157320dfe212118370788cff8124af984c3aac5f543228ad69ebdbbf401db50de77"), bgY.decode("9b7b7b267d3d7bd6cead4242b9bae3bcdf812901bcff06dca582dfa01e2db3cada2e77f665db1e20")});
        kRe.put("SHA-256", new byte[][]{bgY.decode("05e4940b7cbb02e2bfa3cb03e369379f068ff7d51595403c41579791ee585605b8c4a676bf3a9b52"), bgY.decode("dbb50e0e562f3d83fee0c1f020ffbc04f2eaa8e78009cae0eb8c40628a25dcb4ac096732cc2fa1b4")});
        kRe.put("SHA-384", new byte[][]{bgY.decode("5ad1f8c6d18dc235cdb306613926eb9ba67fc910ee7d5483ccc4c9717c576342945aaead78a99bbb"), bgY.decode("03a45f886270781455ff6242d2052b5d84fcea57d95de31fdbd7f973d4027586972da7028fa4c820")});
        kRe.put("SHA-512", new byte[][]{bgY.decode("147abe77d9b19bf6331691eeb3571e55afb406d1ddcd7aa5f1b3de71f0d3eb6949ea580764588000"), bgY.decode("59c18dd408b82f930411bfdeea503d0154a77263c934d7888677ce34018307d4dd035effed210979")});
        kRe.put("SHA-512(224)", new byte[][]{bgY.decode("b8517f43fb91321ee4b6e2d9478970b4fa727518e0176e97536dbb3a55cba46a29557a8dd9db26d4"), bgY.decode("d9d32c83c6586c3ab235830367733fa405ade3c8ff6d24ea28bf6ba3f4ab4784336a32a2a8535be5")});
        kRe.put("SHA-512(256)", new byte[][]{bgY.decode("a33a0d6840f8be385f9aa683cb01e0e0b4d36a1de33e2ea931c015f86f231f574569452950537db7"), bgY.decode("e862780ba48bab8df070be0ca429299a9c744cfa84acb578be5f86155719a23aab6c92b432e9f85b")});
    }
}

