/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aMC;
import com.aspose.html.utils.aMM;
import com.aspose.html.utils.aMX;
import com.aspose.html.utils.aMk;
import com.aspose.html.utils.aMr;
import com.aspose.html.utils.aMs;
import com.aspose.html.utils.aMt;
import com.aspose.html.utils.aMw;
import com.aspose.html.utils.aNL;
import com.aspose.html.utils.aNa;
import com.aspose.html.utils.aNb;
import com.aspose.html.utils.aNi;
import com.aspose.html.utils.aSb;
import com.aspose.html.utils.aTj;
import com.aspose.html.utils.aup;
import com.aspose.html.utils.bgI;
import com.aspose.html.utils.bgP;
import com.aspose.html.utils.bgY;
import com.aspose.html.utils.bgx;
import com.aspose.html.utils.bhh;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public final class aNf {
    public static final String kPF = "READY";
    private static final Object kPG = new Object();
    private static final String[] kPH = new String[]{aMk.class.getName(), aNi.class.getName(), aMr.class.getName(), aMs.class.getName(), aMt.class.getName(), aMw.class.getName(), aMC.class.getName(), aMX.class.getName(), aNa.class.getName(), aNb.class.getName()};
    private static final AtomicBoolean kPI = new AtomicBoolean(false);
    private static volatile a kPJ;
    private static volatile Throwable kPK;

    private aNf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = kPG;
        synchronized (object) {
            if (kPJ == null && kPK == null) {
                try {
                    kPJ = new a();
                    kPJ.run();
                }
                catch (Exception exception) {
                    kPK = exception;
                    aNf.a(new aMM("Module startup failed: " + exception.getMessage(), exception));
                }
                aNf.checksumValidate();
                kPI.set(true);
            } else if (kPK != null) {
                throw new aMM("Module in error status: " + kPK.getMessage(), kPK);
            }
        }
        return kPI.get();
    }

    static boolean isBooting() {
        return !kPI.get();
    }

    private static void checksumValidate() {
        final String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return aNf.getResourceName();
            }
        });
        if (string == null) {
            aNf.a(new aMM("Module checksum failed: unable to find"));
        }
        if (string.startsWith("jrt:/")) {
            aNf.a(new aMM("Module checksum failed: unable to calculate"));
        } else if (aNf.rf(string)) {
            try {
                JarInputStream jarInputStream = new JarInputStream(new URL(string).openStream());
                byte[][] byArray = aNf.a(jarInputStream);
                if (!bgx.areEqual(byArray[0], byArray[1])) {
                    aNf.a(new aMM("Module checksum failed: expected [" + bgY.toHexString(byArray[1]) + "] got [" + bgY.toHexString(byArray[0]) + "]"));
                }
            }
            catch (Exception exception) {
                kPK = exception;
                aNf.a(new aMM("Module checksum failed: " + exception.getMessage(), exception));
            }
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                public JarFile bmO() {
                    try {
                        return new JarFile(string);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                @Override
                public /* synthetic */ Object run() {
                    return this.bmO();
                }
            });
            if (jarFile != null) {
                try {
                    int n2;
                    byte[] byArray = aNf.calculateModuleHMAC(jarFile);
                    InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                    StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
                    while ((n2 = inputStream.read()) >= 0 && n2 != 13 && n2 != 10) {
                        stringBuilder.append((char)n2);
                    }
                    byte[] byArray2 = bgY.decode(stringBuilder.toString().trim());
                    if (!bgx.areEqual(byArray, byArray2)) {
                        aNf.moveToErrorStatus((Object)((Object)new aMM("Module checksum failed: expected [" + stringBuilder.toString().trim() + "] got [" + bgP.fromByteArray(bgY.encode(byArray)))) + "]");
                    }
                }
                catch (Exception exception) {
                    kPK = exception;
                    aNf.a(new aMM("Module checksum failed: " + exception.getMessage(), exception));
                }
            }
        }
    }

    public static String getStatusMessage() {
        try {
            aNf.isReady();
        }
        catch (aMM aMM2) {
            // empty catch block
        }
        if (kPK != null) {
            return kPK.getMessage();
        }
        return kPF;
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            kPK = exceptionInInitializerError.getCause() != null ? exceptionInInitializerError.getCause() : exceptionInInitializerError;
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            kPK = classNotFoundException;
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    public static byte[] getModuleHMAC() {
        try {
            String string = aNf.getResourceName();
            if (aNf.rf(string)) {
                return aNf.a(new JarInputStream(new URL(string).openStream()))[0];
            }
            return aNf.calculateModuleHMAC(new JarFile(string));
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object2;
            aSb aSb2 = new aSb(new aNL());
            aSb2.a(new aTj(bgP.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                Object object4;
                object2 = object3.nextElement();
                if (((ZipEntry)object2).isDirectory() || ((ZipEntry)object2).getName().startsWith("META-INF/") || ((ZipEntry)object2).getName().equals("module-info.class") || (object4 = treeMap.put(((ZipEntry)object2).getName(), object2)) == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                kPK = illegalStateException;
                throw illegalStateException;
            }
            object3 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n2;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = bgP.toUTF8ByteArray(jarEntry.getName());
                aSb2.update((byte)91);
                aSb2.update(byArray, 0, byArray.length);
                aSb2.update(bgI.longToBigEndian(jarEntry.getSize()), 0, 8);
                aSb2.update((byte)93);
                while ((n2 = inputStream.read((byte[])object3, 0, ((Object)object3).length)) != -1) {
                    aSb2.update((byte[])object3, 0, n2);
                }
                inputStream.close();
            }
            aSb2.update((byte)91);
            object2 = bgP.toUTF8ByteArray("END");
            aSb2.update((byte[])object2, 0, ((Object)object2).length);
            aSb2.update((byte)93);
            byte[] byArray = new byte[aSb2.getMacSize()];
            aSb2.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[][] a(JarInputStream jarInputStream) throws Exception {
        try {
            Object object;
            Object object3;
            JarEntry jarEntry;
            aSb aSb2 = new aSb(new aNL());
            aSb2.a(new aTj(bgP.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            byte[] byArray = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.getName().equals("META-INF/HMAC.SHA256")) {
                    byArray = bgY.decode(bgP.fromByteArray(bhh.readAll(jarInputStream)).trim());
                    continue;
                }
                if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/") || jarEntry.getName().equals("module-info.class")) continue;
                object3 = bgP.toUTF8ByteArray(jarEntry.getName());
                ByteArrayOutputStream object22 = new ByteArrayOutputStream();
                object22.write(91);
                object22.write((byte[])object3, 0, ((Object)object3).length);
                object = bhh.readAll(jarInputStream);
                object22.write(bgI.longToBigEndian(((byte[])object).length), 0, 8);
                object22.write(93);
                object22.write((byte[])object, 0, ((byte[])object).length);
                byte[] byArray2 = treeMap.put(jarEntry.getName(), object22.toByteArray());
                if (byArray2 == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                kPK = illegalStateException;
                throw illegalStateException;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object = (byte[])entry.getValue();
                aSb2.update((byte[])object, 0, ((byte[])object).length);
            }
            aSb2.update((byte)91);
            object3 = bgP.toUTF8ByteArray("END");
            aSb2.update((byte[])object3, 0, ((Object)object3).length);
            aSb2.update((byte)93);
            byte[] byArray3 = new byte[aSb2.getMacSize()];
            aSb2.doFinal(byArray3, 0);
            object = new byte[][]{byArray3, byArray};
            return object;
        }
        finally {
            jarInputStream.close();
        }
    }

    private static String getResourceName() {
        String string = null;
        String string2 = aup.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String string3 = aNf.getMarker(aup.class, string2);
        if (string3 != null) {
            if (string3.startsWith("jar:") && string3.contains("!/")) {
                try {
                    String string4;
                    int n2 = string3.indexOf(58, 4);
                    if (n2 == -1) {
                        return null;
                    }
                    string = string4 = URLDecoder.decode(string3.substring(n2 + 1, string3.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else if (string3.startsWith("file:") && string3.endsWith(".jar")) {
                try {
                    String string5;
                    string = string5 = URLDecoder.decode(string3.substring("file:".length()), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else {
                if (string3.startsWith("jrt:")) {
                    return string3;
                }
                if (string3.startsWith("file:")) {
                    return string3;
                }
                if (aNf.rf(string3)) {
                    return string3;
                }
            }
        }
        return string;
    }

    static void moveToErrorStatus(String string) {
        aNf.a(new aMM(string));
    }

    static void a(aMM aMM2) {
        kPK = aMM2;
        throw (aMM)((Object)kPK);
    }

    public static boolean isErrorStatus() {
        return kPK != null;
    }

    static String getMarker(final Class clazz, final String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                        return codeSource.getLocation();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (t2 != null) {
                return t2.toString();
            }
            return classLoader.getResource(string).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(string).toString();
            }
        });
    }

    private static boolean rf(String string) {
        return (string.startsWith("http://") || string.startsWith("https://")) && string.endsWith(".jar");
    }

    static class a {
        a() {
        }

        void run() throws Exception {
            for (String string : kPH) {
                if (aNf.isErrorStatus()) continue;
                aNf.loadClass(string);
            }
        }
    }
}

