/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aNt;
import com.aspose.html.utils.bgG;
import com.aspose.html.utils.bgH;

class aNP
extends aNt {
    private final int kSV;
    private long H1t;
    private long H2t;
    private long H3t;
    private long H4t;
    private long H5t;
    private long H6t;
    private long H7t;
    private long H8t;

    public aNP(int n2) {
        if (n2 >= 512) {
            throw new IllegalArgumentException("bitLength cannot be >= 512");
        }
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("bitLength needs to be a multiple of 8");
        }
        if (n2 == 384) {
            throw new IllegalArgumentException("bitLength cannot be 384 use SHA384 instead");
        }
        this.kSV = n2 / 8;
        this.tIvGenerate(this.kSV * 8);
        this.reset();
    }

    public aNP(aNP aNP2) {
        super(aNP2);
        this.kSV = aNP2.kSV;
        this.a((bgG)aNP2);
    }

    public String getAlgorithmName() {
        return "SHA-512/" + Integer.toString(this.kSV * 8);
    }

    public int getDigestSize() {
        return this.kSV;
    }

    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        aNP.longToBigEndian(this.H1, byArray, n2, this.kSV);
        aNP.longToBigEndian(this.H2, byArray, n2 + 8, this.kSV - 8);
        aNP.longToBigEndian(this.H3, byArray, n2 + 16, this.kSV - 16);
        aNP.longToBigEndian(this.H4, byArray, n2 + 24, this.kSV - 24);
        aNP.longToBigEndian(this.H5, byArray, n2 + 32, this.kSV - 32);
        aNP.longToBigEndian(this.H6, byArray, n2 + 40, this.kSV - 40);
        aNP.longToBigEndian(this.H7, byArray, n2 + 48, this.kSV - 48);
        aNP.longToBigEndian(this.H8, byArray, n2 + 56, this.kSV - 56);
        this.reset();
        return this.kSV;
    }

    public void reset() {
        super.reset();
        this.H1 = this.H1t;
        this.H2 = this.H2t;
        this.H3 = this.H3t;
        this.H4 = this.H4t;
        this.H5 = this.H5t;
        this.H6 = this.H6t;
        this.H7 = this.H7t;
        this.H8 = this.H8t;
    }

    private void tIvGenerate(int n2) {
        this.H1 = -3482333909917012819L;
        this.H2 = 2216346199247487646L;
        this.H3 = -7364697282686394994L;
        this.H4 = 65953792586715988L;
        this.H5 = -816286391624063116L;
        this.H6 = 4512832404995164602L;
        this.H7 = -5033199132376557362L;
        this.H8 = -124578254951840548L;
        this.update((byte)83);
        this.update((byte)72);
        this.update((byte)65);
        this.update((byte)45);
        this.update((byte)53);
        this.update((byte)49);
        this.update((byte)50);
        this.update((byte)47);
        if (n2 > 100) {
            this.update((byte)(n2 / 100 + 48));
            this.update((byte)((n2 %= 100) / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else if (n2 > 10) {
            this.update((byte)(n2 / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else {
            this.update((byte)(n2 + 48));
        }
        this.finish();
        this.H1t = this.H1;
        this.H2t = this.H2;
        this.H3t = this.H3;
        this.H4t = this.H4;
        this.H5t = this.H5;
        this.H6t = this.H6;
        this.H7t = this.H7;
        this.H8t = this.H8;
    }

    private static void longToBigEndian(long l2, byte[] byArray, int n2, int n3) {
        if (n3 > 0) {
            aNP.intToBigEndian((int)(l2 >>> 32), byArray, n2, n3);
            if (n3 > 4) {
                aNP.intToBigEndian((int)(l2 & 0xFFFFFFFFL), byArray, n2 + 4, n3 - 4);
            }
        }
    }

    private static void intToBigEndian(int n2, byte[] byArray, int n3, int n4) {
        int n5 = Math.min(4, n4);
        while (--n5 >= 0) {
            int n6 = 8 * (3 - n5);
            byArray[n3 + n5] = (byte)(n2 >>> n6);
        }
    }

    public bgG biX() {
        return new aNP(this);
    }

    public void a(bgG bgG2) {
        aNP aNP2 = (aNP)bgG2;
        if (this.kSV != aNP2.kSV) {
            throw new bgH("digestLength inappropriate in other");
        }
        super.a(aNP2);
        this.H1t = aNP2.H1t;
        this.H2t = aNP2.H2t;
        this.H3t = aNP2.H3t;
        this.H4t = aNP2.H4t;
        this.H5t = aNP2.H5t;
        this.H6t = aNP2.H6t;
        this.H7t = aNP2.H7t;
        this.H8t = aNP2.H8t;
    }
}

