/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aJy;
import com.aspose.html.utils.bgx;

public class aML {
    private final byte[] kLu;
    private final long kLv;
    private final int kLw;
    private long counterValue;
    private boolean counterExhausted;

    public aML(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException("'baseNonce' cannot be null");
        }
        if (byArray.length < 8) {
            throw new IllegalArgumentException("'baseNonce' must be at least 8 bytes");
        }
        if (n2 < 1 || n2 > 64) {
            throw new IllegalArgumentException("'counterBits' must be from 1 to 64 bits");
        }
        if (aJy.isInApprovedOnlyMode()) {
            if (byArray.length < 12) {
                throw new IllegalArgumentException("Approved mode requires 'baseNonce' of at least 12 bytes");
            }
            if (n2 < 32) {
                throw new IllegalArgumentException("Approved mode requires 'counterBits' of at least 32 bits");
            }
        }
        this.kLu = bgx.clone(byArray);
        this.kLv = -1L >>> 64 - n2;
        this.kLw = (n2 + 7) / 8;
        this.counterValue = 0L;
        this.counterExhausted = false;
    }

    public void generateNonce(byte[] byArray) {
        if (this.kLu.length != byArray.length) {
            throw new IllegalArgumentException("'nonce' length must match the base nonce length (" + this.kLu.length + " bytes)");
        }
        if (this.counterExhausted) {
            throw new IllegalStateException("TLS nonce generator exhausted");
        }
        System.arraycopy(this.kLu, 0, byArray, 0, this.kLu.length);
        this.xorCounter(byArray, this.kLu.length - this.kLw);
        this.counterExhausted |= (++this.counterValue & this.kLv) == 0L;
    }

    private void xorCounter(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.kLw; ++i2) {
            int n3 = n2 + i2;
            byArray[n3] = (byte)(byArray[n3] ^ (byte)(this.counterValue >>> (this.kLw - 1 - i2) * 8));
        }
    }
}

