/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.messagehandlers;

import com.aspose.html.IDisposable;
import com.aspose.html.net.ContentHeaders;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.INetworkOperationContext;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.RequestHeaders;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.net.StringContent;
import com.aspose.html.net.messagefilters.ProtocolMessageFilter;
import com.aspose.html.utils.JK;
import com.aspose.html.utils.JW;
import com.aspose.html.utils.aaB;
import com.aspose.html.utils.adw;
import com.aspose.html.utils.cl;
import com.aspose.html.utils.ju;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Diagnostics.Stopwatch;
import com.aspose.html.utils.ms.System.Net.Cookie;
import com.aspose.html.utils.ms.System.Net.CookieCollection;
import com.aspose.html.utils.ms.System.Net.CredentialCache;
import com.aspose.html.utils.ms.System.Net.HttpWebRequest;
import com.aspose.html.utils.ms.System.Net.WebHeaderCollection;
import com.aspose.html.utils.ms.System.Net.WebRequest;
import com.aspose.html.utils.ms.System.Net.WebResponse;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;
import com.aspose.html.utils.net.CookieContainer;
import com.aspose.html.utils.net.ICredentials;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpProtocolMessageHandler
extends MessageHandler {
    private static final StringSwitchMap gbT = new StringSwitchMap("Accept", "User-Agent", "Content-Type", "Expect", "Referer");

    public HttpProtocolMessageHandler() {
        this.getFilters().addItem(new ProtocolMessageFilter(aaB.a(ju.j.bUU), aaB.a(ju.j.bUV)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(WebHeaderCollection webHeaderCollection, WebRequest webRequest) {
        IEnumerator iEnumerator = webHeaderCollection.getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (!WebHeaderCollection.isRestricted(string)) {
                    webRequest.getHeaders().set(string, webHeaderCollection.get_Item(string));
                    continue;
                }
                HttpWebRequest httpWebRequest = Operators.as(webRequest, HttpWebRequest.class);
                if (httpWebRequest == null) continue;
                switch (gbT.of(string)) {
                    case 0: {
                        httpWebRequest.setAccept(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 1: {
                        httpWebRequest.setUserAgent(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 2: {
                        httpWebRequest.setContentType(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 3: {
                        httpWebRequest.setExpect(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 4: {
                        httpWebRequest.setReferer(webHeaderCollection.get_Item(string));
                    }
                }
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(WebResponse webResponse, ResponseMessage responseMessage) {
        IEnumerator iEnumerator = webResponse.getHeaders().getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (WebHeaderCollection.isRestricted(string, true)) continue;
                responseMessage.getHeaders().add(string, webResponse.getHeaders().get(string));
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    private static void a(RequestHeaders requestHeaders, HttpURLConnection httpURLConnection) {
    }

    private static void a(ContentHeaders contentHeaders, HttpURLConnection httpURLConnection) {
    }

    @Override
    public void invoke(INetworkOperationContext iNetworkOperationContext) {
        if (cl.gL().getEnabled()) {
            cl.gL().rg().qZ();
        }
        Stopwatch stopwatch = null;
        try {
            HttpURLConnection httpURLConnection = HttpProtocolMessageHandler.c(iNetworkOperationContext);
            if (cl.gL().getEnabled()) {
                stopwatch = Stopwatch.startNew();
            }
            HttpProtocolMessageHandler.a(iNetworkOperationContext, httpURLConnection, stopwatch);
        }
        catch (IOException iOException) {
            if (cl.gL().getEnabled() && stopwatch != null) {
                stopwatch.stop();
                cl.gL().rh().setValue(stopwatch.getElapsedMilliseconds());
            }
            iNetworkOperationContext.setResponse(new ResponseMessage(400));
            iNetworkOperationContext.getResponse().setContent(new JK(iOException));
        }
        this.next(iNetworkOperationContext);
    }

    private static void a(INetworkOperationContext iNetworkOperationContext, HttpURLConnection httpURLConnection, Stopwatch stopwatch) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        if (cl.gL().getEnabled()) {
            stopwatch.stop();
            cl.gL().rh().setValue(stopwatch.getElapsedMilliseconds());
        }
        iNetworkOperationContext.setResponse(new ResponseMessage(httpURLConnection.getResponseCode()));
        iNetworkOperationContext.getResponse().setRequest(iNetworkOperationContext.getRequest());
        iNetworkOperationContext.getResponse().setContent(new StringContent(stringBuffer.toString()));
        iNetworkOperationContext.getResponse().setCookies(HttpProtocolMessageHandler.a(httpURLConnection));
        HttpProtocolMessageHandler.a(httpURLConnection, iNetworkOperationContext.getResponse());
    }

    private static HttpURLConnection c(INetworkOperationContext iNetworkOperationContext) throws IOException {
        String string;
        String string2 = iNetworkOperationContext.getRequest().getRequestUri().getHref();
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod(iNetworkOperationContext.getRequest().getMethod() != null ? iNetworkOperationContext.getRequest().getMethod().UC() : HttpMethod.getGet().UC());
        ICredentials iCredentials = iNetworkOperationContext.getRequest().getCredentials();
        if (iCredentials == null) {
            iCredentials = CredentialCache.getDefaultCredentials();
        }
        JW.a(httpURLConnection, iCredentials);
        JW.a(httpURLConnection, iNetworkOperationContext.getRequest().getPreAuthenticate());
        int n2 = new Double(iNetworkOperationContext.getRequest().getTimeout().getTotalMilliseconds()).intValue();
        httpURLConnection.setReadTimeout(n2);
        HttpProtocolMessageHandler.a(iNetworkOperationContext, httpURLConnection);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setAllowUserInteraction(false);
        if (StringExtensions.isNullOrEmpty(HttpProtocolMessageHandler.b(httpURLConnection))) {
            HttpProtocolMessageHandler.a(httpURLConnection, "*/*");
        }
        if ((string = httpURLConnection.getRequestProperty("User-Agent")) == null) {
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36");
        }
        if ((HttpMethod.getPost().equals(iNetworkOperationContext.getRequest().getMethod()) || HttpMethod.getPut().equals(iNetworkOperationContext.getRequest().getMethod())) && iNetworkOperationContext.getRequest().getContent() != null) {
            HttpProtocolMessageHandler.a(iNetworkOperationContext.getRequest().getContent().getHeaders(), httpURLConnection);
        }
        HttpProtocolMessageHandler.a(iNetworkOperationContext.getRequest().getHeaders(), httpURLConnection);
        int n3 = httpURLConnection.getResponseCode();
        if (n3 == 302 || n3 == 301) {
            String string3 = httpURLConnection.getHeaderField("Location");
            URL uRL2 = new URL(string3);
            httpURLConnection = (HttpURLConnection)uRL2.openConnection();
        }
        return httpURLConnection;
    }

    private static void a(INetworkOperationContext iNetworkOperationContext, HttpURLConnection httpURLConnection) {
        CookieContainer cookieContainer = iNetworkOperationContext.getRequest().getCookieContainer();
        if (cookieContainer == null) {
            cookieContainer = new CookieContainer();
        }
        httpURLConnection.setRequestProperty("Cookie", HttpProtocolMessageHandler.a(cookieContainer));
    }

    private static String a(CookieContainer cookieContainer) {
        cookieContainer.getCount();
        Field[] fieldArray = cookieContainer.getClass().getDeclaredFields();
        String string = null;
        CookieCollection cookieCollection = null;
        for (Field field : fieldArray) {
            if (!field.getClass().isAssignableFrom(CookieCollection.class)) continue;
            string = field.getName();
            try {
                cookieCollection = (CookieCollection)field.get(cookieContainer);
            }
            catch (IllegalAccessException illegalAccessException) {}
            break;
        }
        if (cookieCollection != null) {
            // empty if block
        }
        return "";
    }

    public static void a(HttpURLConnection httpURLConnection, ResponseMessage responseMessage) {
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        for (String string : set) {
            List<String> list = map.get(string);
            if (string == null || WebHeaderCollection.isRestricted(string, true)) continue;
            for (String string2 : list) {
                responseMessage.getHeaders().add(string, string2);
            }
        }
    }

    private static CookieCollection a(HttpURLConnection httpURLConnection) {
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        CookieCollection cookieCollection = new CookieCollection();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!"Set-Cookie".equalsIgnoreCase(string)) continue;
            List<String> list = map.get(string);
            for (String string2 : list) {
                String[] stringArray = string2.split(";\\s*");
                String string3 = stringArray[0];
                String string4 = null;
                String string5 = null;
                String string6 = null;
                boolean bl2 = false;
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    if ("secure".equalsIgnoreCase(stringArray[i2])) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[i2].indexOf(61) <= 0) continue;
                    String[] stringArray2 = stringArray[i2].split("=");
                    if ("expires".equalsIgnoreCase(stringArray2[0])) {
                        string4 = stringArray2[1];
                        continue;
                    }
                    if ("domain".equalsIgnoreCase(stringArray2[0])) {
                        string6 = stringArray2[1];
                        continue;
                    }
                    if (!"path".equalsIgnoreCase(stringArray2[0])) continue;
                    string5 = stringArray2[1];
                }
                Cookie cookie = new Cookie();
                cookie.setName(string);
                try {
                    cookie.setExpires(adw.lS(string4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cookie.setPath(string5);
                cookie.setDomain(string6);
                cookie.setSecure(bl2);
                cookie.setValue(string3);
                cookieCollection.add(cookie);
            }
        }
        return cookieCollection;
    }

    private static void a(HttpURLConnection httpURLConnection, String string) {
        httpURLConnection.setRequestProperty("Accept", string);
    }

    private static String b(HttpURLConnection httpURLConnection) {
        return httpURLConnection.getRequestProperty("Accept");
    }
}

