/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IDocumentInit;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.Event;
import com.aspose.html.io.IOutputStorage;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.saving.TextSaveOptions;
import com.aspose.html.serialization.manager.resources.handlers.MHTMLHandlerFactory;
import com.aspose.html.serialization.manager.resources.handlers.SingleDocumentHandlerFactory;
import com.aspose.html.utils.DF;
import com.aspose.html.utils.DG;
import com.aspose.html.utils.Ez;
import com.aspose.html.utils.FI;
import com.aspose.html.utils.Ka;
import com.aspose.html.utils.KeyValuePair;
import com.aspose.html.utils.P;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.T;
import com.aspose.html.utils.UH;
import com.aspose.html.utils.VU;
import com.aspose.html.utils.WA;
import com.aspose.html.utils.Wo;
import com.aspose.html.utils.Wp;
import com.aspose.html.utils.Ws;
import com.aspose.html.utils.Yr;
import com.aspose.html.utils.an;
import com.aspose.html.utils.bW;
import com.aspose.html.utils.bhz;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.gj;
import com.aspose.html.utils.jK;
import com.aspose.html.utils.ju;
import com.aspose.html.utils.lF;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.vu;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String Hy;
    private IViewCSS Hz;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(InputStream inputStream, String string) {
        this(Stream.fromJava(inputStream), string, new Configuration());
    }

    public HTMLDocument(P p2) {
        super(HTMLDocument.e(p2));
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(RequestMessage requestMessage) {
        this(requestMessage, new Configuration());
    }

    public HTMLDocument(RequestMessage requestMessage, Configuration configuration) {
        this(requestMessage, configuration, 1);
    }

    private HTMLDocument(final RequestMessage requestMessage, Configuration configuration, final byte by2) {
        super(HTMLDocument.a(new P(configuration), new Document.c(){
            {
                this.a(vu.dwh);
                this.a(requestMessage);
                this.setFlags(by2);
            }
        }));
    }

    public HTMLDocument(Stream stream, Url url) {
        this(stream, url, new Configuration());
    }

    public HTMLDocument(Stream stream, Url url, Configuration configuration) {
        this(Ka.a(stream, url), configuration, 3);
    }

    public HTMLDocument(Stream stream, String string) {
        this(stream, string, new Configuration());
    }

    public HTMLDocument(Stream stream, String string, Configuration configuration) {
        this(Ka.f(stream, string), configuration, 3);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(Ka.l(url), configuration, 3);
    }

    public HTMLDocument(String string) {
        this(new T(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String string, Configuration configuration) {
        this(new T(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String string, Url url) {
        this(string, url, new Configuration());
    }

    public HTMLDocument(String string, Url url, Configuration configuration) {
        this(Ka.a(string, url), configuration, 3);
    }

    public HTMLDocument(String string, String string2) {
        this(string, string2, new Configuration());
    }

    public HTMLDocument(String string, String string2, Configuration configuration) {
        this(Ka.af(string, string2), configuration, 3);
    }

    private static IDocumentInit e(P p2) {
        return HTMLDocument.a(p2, null);
    }

    private static IDocumentInit a(P p2, Document.c c2) {
        jK jK2 = p2.ai().l(p2);
        jK2.cI(1);
        jK2.b(new bhz<Document, Event>(){

            public void a(Document document, Event event) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                if (hTMLDocument.getBody() != null) {
                    hTMLDocument.getBody().dispatchEvent(event);
                } else {
                    hTMLDocument.dispatchEvent(event);
                }
            }

            @Override
            public /* synthetic */ void invoke(Object object, Object object2) {
                this.a((Document)object, (Event)object2);
            }
        });
        jK2.a(c2);
        return jK2;
    }

    public final HTMLCollection getAnchors() {
        return new bW(this, new DG("A"));
    }

    public final HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new bW(this, new DG("APPLET", "OBJECT", "EMBED"));
    }

    public final HTMLElement getBody() {
        bW bW2 = new bW(this, new DG("BODY", "FRAMESET"));
        return (HTMLElement)Ez.c(bW2);
    }

    public final void setBody(HTMLElement hTMLElement) {
        gj.d(hTMLElement, "value");
        HTMLElement hTMLElement2 = this.getBody();
        if (hTMLElement2 != null) {
            this.getDocumentElement().replaceChild(hTMLElement2, hTMLElement);
        } else {
            this.getDocumentElement().appendChild(hTMLElement);
        }
    }

    public final String ce() {
        return this.Hy;
    }

    final void V(String string) {
        this.Hy = string;
    }

    public final String getDomain() {
        return this.getLocation().getHost();
    }

    public final HTMLCollection getForms() {
        return new bW(this, new DF("FORM"));
    }

    public final HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    public final HTMLCollection getLinks() {
        return new bW(this, new DG("A", "AREA"));
    }

    public final String getReferrer() {
        return StringExtensions.Empty;
    }

    public final String getTitle() {
        Element element = Ez.c(this.getElementsByTagName(ju.i.bRv.dB()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    public final void setTitle(String string) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), ju.g.bNB)) {
            Element element = Ez.c(this.getElementsByTagName(an.a(ju.i.bRv)));
            if (element != null) {
                element.setTextContent(string);
                return;
            }
            Element element2 = Ez.c(this.getElementsByTagName(an.a(ju.i.bPG)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(ju.i.bRv.dB());
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }

    @Override
    public final ICSSStyleDeclaration getOverrideStyle(Element element, String string) {
        P p2 = (P)this.getContext();
        return ((lF)p2.ag()).getOverrideStyle(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(IDevice iDevice) {
        Yr yr2 = this.getContext().getService(Yr.class);
        IDisposable iDisposable = yr2.alf();
        try {
            yr2.a(iDisposable, iDevice, this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(IOutputStorage iOutputStorage) {
        this.save(iOutputStorage, 0);
    }

    public final void save(IOutputStorage iOutputStorage, int n2) {
        switch (n2) {
            case 0: {
                this.save(iOutputStorage, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(iOutputStorage, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(iOutputStorage, TextSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(iOutputStorage, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, HTMLSaveOptions hTMLSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a(Document.a.z(this), hTMLSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.b(new VU(wo2.any(), hTMLSaveOptions));
            wo2.a(iOutputStorage);
            wo2.c(Document.a.z(this), ".htm");
            wp2.H(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MHTMLSaveOptions mHTMLSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.cz(false);
            wo2.a(new MHTMLHandlerFactory());
            wo2.a(new Ws());
            wo2.a(new FI(iOutputStorage, wo2.getBoundary()));
            wo2.c(this.getLocation(), ".mht");
            wp2.H(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MarkdownSaveOptions markdownSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.b(new WA(markdownSaveOptions));
            wo2.a(new SingleDocumentHandlerFactory());
            wo2.a(iOutputStorage);
            wo2.c(this.getLocation(), ".md");
            wp2.i(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(Url url) {
        this.save(url, 0);
    }

    public final void save(Url url, int n2) {
        switch (n2) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(url, new MHTMLSaveOptions());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, HTMLSaveOptions hTMLSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.q(url);
            wp2.H(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MHTMLSaveOptions mHTMLSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.cz(false);
            wo2.a(new MHTMLHandlerFactory());
            wo2.a(new Ws());
            wo2.a(new FI(wo2.anD(), wo2.getBoundary()));
            wo2.o(url);
            wo2.q(url);
            wp2.H(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MarkdownSaveOptions markdownSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.b(new WA(markdownSaveOptions));
            wo2.a(new SingleDocumentHandlerFactory());
            wo2.q(url);
            wp2.i(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(String string) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public final void save(String string, int n2) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), n2);
    }

    public final void save(String string, HTMLSaveOptions hTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), hTMLSaveOptions);
    }

    public final void save(String string, MHTMLSaveOptions mHTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), mHTMLSaveOptions);
    }

    public final void save(String string, MarkdownSaveOptions markdownSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), markdownSaveOptions);
    }

    public final void save(String string, TextSaveOptions textSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), textSaveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, TextSaveOptions textSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), textSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.a(new SingleDocumentHandlerFactory());
            wo2.q(url);
            String string = UH.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(wo2.anC(), new String[0]), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        this.a(iOutputStorage, textSaveOptions);
    }

    private void a(Url url, TextSaveOptions textSaveOptions) {
        String string = UH.f(this);
        UH.save(url.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        Wp wp2 = new Wp((P)this.getContext());
        IDisposable iDisposable = wp2.a((Url)this.getLocation(), textSaveOptions);
        try {
            Wo wo2 = wp2.anP();
            wo2.a(new SingleDocumentHandlerFactory());
            wo2.a(iOutputStorage);
            wo2.c(this.getLocation(), ".txt");
            String string = UH.f(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(URI.create(iOutputStorage.toString())), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }
}

