/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvRSAPrivateKey
implements RSAPrivateKey,
Destroyable,
ProvKey<AsymmetricRSAPrivateKey> {
    static final long serialVersionUID = 5110188922551353628L;
    private transient AsymmetricRSAPrivateKey baseKey;

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKey rSAPrivateKey) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
    }

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKeySpec rSAPrivateKeySpec) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
    }

    ProvRSAPrivateKey(AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
        this.baseKey = asymmetricRSAPrivateKey;
    }

    @Override
    public AsymmetricRSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this.baseKey);
        return this.baseKey;
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.baseKey.getPrivateExponent();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this.baseKey);
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        if (this.isDestroyed()) {
            stringBuilder.append("RSA Private Key [DESTROYED]").append(string);
        } else {
            stringBuilder.append("RSA Private Key [").append(KeyUtil.generateFingerPrint(this.getModulus())).append("],[]").append(string);
            stringBuilder.append("         modulus: ").append(this.getModulus().toString(16)).append(string);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvRSAPrivateKey)) {
            return false;
        }
        ProvRSAPrivateKey provRSAPrivateKey = (ProvRSAPrivateKey)object;
        return this.baseKey.equals(provRSAPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

