/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class ProvEdDSAPublicKey
implements PublicKey,
EdDSAKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPublicKey baseKey;

    ProvEdDSAPublicKey(AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        this.baseKey = asymmetricEdDSAPublicKey;
    }

    ProvEdDSAPublicKey(byte[] byArray) {
        this.baseKey = new AsymmetricEdDSAPublicKey(byArray);
    }

    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricEdDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvEdDSAPublicKey)) {
            return false;
        }
        ProvEdDSAPublicKey provEdDSAPublicKey = (ProvEdDSAPublicKey)object;
        return Arrays.areEqual(provEdDSAPublicKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricEdDSAPublicKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

