/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PKIXNameConstraintValidator;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.provider.AnnotatedException;
import org.bouncycastle.jcajce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jcajce.provider.PKIXPolicyNode;
import org.bouncycastle.jcajce.provider.RFC3280CertPathUtilities;

class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private final Provider fipsProvider;

    PKIXCertPathValidatorSpi(Provider provider) {
        this.fipsProvider = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        PKIXExtendedParameters pKIXExtendedParameters;
        if (certPathParameters instanceof PKIXExtendedParameters) {
            pKIXExtendedParameters = (PKIXExtendedParameters)certPathParameters;
        } else if (certPathParameters instanceof PKIXExtendedBuilderParameters) {
            pKIXExtendedParameters = ((PKIXExtendedBuilderParameters)certPathParameters).getBaseParameters();
        } else if (certPathParameters instanceof PKIXParameters) {
            pKIXExtendedParameters = new PKIXExtendedParameters.Builder((PKIXParameters)certPathParameters).build();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + PKIXExtendedParameters.class.getName() + " instance.");
        }
        if (pKIXExtendedParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = pKIXExtendedParameters.getInitialPolicies();
        try {
            trustAnchor = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)list.get(list.size() - 1), pKIXExtendedParameters.getTrustAnchors(), pKIXExtendedParameters.getSigProvider());
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), (Throwable)annotatedException, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        pKIXExtendedParameters = new PKIXExtendedParameters.Builder(pKIXExtendedParameters).setTrustAnchor(trustAnchor).build();
        int n3 = 0;
        List[] listArray = new ArrayList[n2 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        HashSet hashSet3 = new HashSet();
        int n4 = pKIXExtendedParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = pKIXExtendedParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = pKIXExtendedParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = CertPathValidatorUtilities.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        int n7 = n2;
        if (pKIXExtendedParameters.getTargetConstraints() != null && !pKIXExtendedParameters.getTargetConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = pKIXExtendedParameters.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            boolean bl2;
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            boolean bl3 = bl2 = n3 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n3);
            }
            RFC3280CertPathUtilities.processCertA(certPath, pKIXExtendedParameters, n3, publicKey, bl2, x500Principal, x509Certificate, this.fipsProvider);
            RFC3280CertPathUtilities.processCertBC(certPath, n3, pKIXNameConstraintValidator);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertD(certPath, n3, hashSet3, pKIXPolicyNode, listArray, n5);
            pKIXPolicyNode = RFC3280CertPathUtilities.processCertE(certPath, n3, pKIXPolicyNode);
            RFC3280CertPathUtilities.processCertF(certPath, n3, pKIXPolicyNode, n4);
            if (n8 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n3);
            }
            RFC3280CertPathUtilities.prepareNextCertA(certPath, n3);
            pKIXPolicyNode = RFC3280CertPathUtilities.prepareCertB(certPath, n3, listArray, pKIXPolicyNode, n6);
            RFC3280CertPathUtilities.prepareNextCertG(certPath, n3, pKIXNameConstraintValidator);
            n4 = RFC3280CertPathUtilities.prepareNextCertH1(certPath, n3, n4);
            n6 = RFC3280CertPathUtilities.prepareNextCertH2(certPath, n3, n6);
            n5 = RFC3280CertPathUtilities.prepareNextCertH3(certPath, n3, n5);
            n4 = RFC3280CertPathUtilities.prepareNextCertI1(certPath, n3, n4);
            n6 = RFC3280CertPathUtilities.prepareNextCertI2(certPath, n3, n6);
            n5 = RFC3280CertPathUtilities.prepareNextCertJ(certPath, n3, n5);
            RFC3280CertPathUtilities.prepareNextCertK(certPath, n3);
            n7 = RFC3280CertPathUtilities.prepareNextCertL(certPath, n3, n7);
            n7 = RFC3280CertPathUtilities.prepareNextCertM(certPath, n3, n7);
            RFC3280CertPathUtilities.prepareNextCertN(certPath, n3);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(RFC3280CertPathUtilities.CERT_SUPPORTED_CRITICAL_EXTENSIONS);
            } else {
                hashSet = new HashSet();
            }
            RFC3280CertPathUtilities.prepareNextCertO(certPath, n3, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = CertPathValidatorUtilities.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = CertPathValidatorUtilities.getNextWorkingKey(certPath.getCertificates(), n3, this.fipsProvider);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n3);
            }
            algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
            aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            aSN1Encodable = algorithmIdentifier.getParameters();
        }
        n4 = RFC3280CertPathUtilities.wrapupCertA(n4, x509Certificate2);
        n4 = RFC3280CertPathUtilities.wrapupCertB(certPath, n3 + 1, n4);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(RFC3280CertPathUtilities.CERT_SUPPORTED_CRITICAL_EXTENSIONS);
            set2.remove(Extension.extendedKeyUsage.getId());
        } else {
            set2 = new HashSet<String>();
        }
        RFC3280CertPathUtilities.wrapupCertF(certPath, n3 + 1, list2, set2);
        hashSet = RFC3280CertPathUtilities.wrapupCertG(certPath, pKIXExtendedParameters, set, n3 + 1, listArray, pKIXPolicyNode, hashSet3);
        if (n4 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }
}

