/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jcajce.KTSKeyWithEncapsulation;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.spec.KTSExtractKeySpec;
import org.bouncycastle.jcajce.spec.KTSGenerateKeySpec;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.util.Arrays;

class KtsCipherSpi
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final String algorithmName;
    private SecretKeyFactory kemFact;
    private KTSParameterSpec ktsParameterSpec;
    private RSAPublicKey wrapKey;
    private RSAPrivateKey unwrapKey;
    private SecureRandom random;
    private AlgorithmParameters engineParams;

    KtsCipherSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string) throws NoSuchAlgorithmException {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.algorithmName = string;
        this.kemFact = SecretKeyFactory.getInstance("RSA-KAS-KEM", bouncyCastleFipsProvider);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " unknown");
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)key);
            return rSAKey.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an valid key!");
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int n2) {
        return -1;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance(this.algorithmName, this.fipsProvider);
                this.engineParams.init(this.ktsParameterSpec);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return this.engineParams;
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secureRandom == null) {
            this.random = this.fipsProvider.getDefaultSecureRandom();
        }
        if (algorithmParameterSpec == null) {
            this.ktsParameterSpec = new KTSParameterSpec.Builder("AES", 128).build();
        } else {
            if (!(algorithmParameterSpec instanceof KTSParameterSpec)) {
                throw new InvalidAlgorithmParameterException(this.algorithmName + " can only accept KTSParameterSpec");
            }
            this.ktsParameterSpec = (KTSParameterSpec)algorithmParameterSpec;
        }
        if (n2 == 3) {
            if (!(key instanceof RSAPublicKey)) throw new InvalidKeyException("Only an RSA public key can be used for wrapping");
            this.wrapKey = (RSAPublicKey)key;
            return;
        } else {
            if (n2 != 4) throw new InvalidParameterException("Cipher only valid for wrapping/unwrapping");
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("Only an RSA private key can be used for unwrapping");
            this.unwrapKey = (RSAPrivateKey)key;
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        KTSParameterSpec kTSParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                kTSParameterSpec = algorithmParameters.getParameterSpec(KTSParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, kTSParameterSpec, this.random);
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            KTSGenerateKeySpec kTSGenerateKeySpec = new KTSGenerateKeySpec.Builder(this.wrapKey, this.ktsParameterSpec.getKeyAlgorithmName(), this.ktsParameterSpec.getKeySize(), this.ktsParameterSpec.getOtherInfo()).withKdfAlgorithm(this.ktsParameterSpec.getKdfAlgorithm()).withSecureRandom(this.random).withParameterSpec(this.ktsParameterSpec.getParameterSpec()).build();
            KTSKeyWithEncapsulation kTSKeyWithEncapsulation = (KTSKeyWithEncapsulation)this.kemFact.generateSecret(kTSGenerateKeySpec);
            Cipher cipher = Cipher.getInstance(this.ktsParameterSpec.getKeyAlgorithmName(), this.fipsProvider);
            cipher.init(3, (Key)kTSKeyWithEncapsulation, this.random);
            return Arrays.concatenate(kTSKeyWithEncapsulation.getEncapsulation(), cipher.wrap(key));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalBlockSizeException("Unable to generate KTS secret: " + generalSecurityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalBlockSizeException("Unable to generate KTS secret: " + illegalArgumentException.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] byArray2 = new byte[(this.unwrapKey.getModulus().bitLength() + 7) / 8];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            KTSExtractKeySpec kTSExtractKeySpec = new KTSExtractKeySpec.Builder(this.unwrapKey, byArray2, this.ktsParameterSpec.getKeyAlgorithmName(), this.ktsParameterSpec.getKeySize(), this.ktsParameterSpec.getOtherInfo()).withKdfAlgorithm(this.ktsParameterSpec.getKdfAlgorithm()).withParameterSpec(this.ktsParameterSpec.getParameterSpec()).build();
            KTSKeyWithEncapsulation kTSKeyWithEncapsulation = (KTSKeyWithEncapsulation)this.kemFact.generateSecret(kTSExtractKeySpec);
            Cipher cipher = Cipher.getInstance(this.ktsParameterSpec.getKeyAlgorithmName(), this.fipsProvider);
            cipher.init(4, (Key)kTSKeyWithEncapsulation, this.random);
            byte[] byArray3 = new byte[byArray.length - byArray2.length];
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            return cipher.unwrap(byArray3, string, n2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (generalSecurityException instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)generalSecurityException;
            }
            throw new NoSuchAlgorithmException("Unable to generate KTS secret: " + generalSecurityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchAlgorithmException("Unable to generate KTS secret: " + illegalArgumentException.getMessage());
        }
    }
}

