/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.util.Arrays;

public final class KDFDoublePipelineIterationParameters
implements DerivationParameters {
    public static final int BEFORE_ITER = 0;
    public static final int AFTER_ITER = 1;
    public static final int AFTER_FIXED = 2;
    private static final int UNUSED_R = 32;
    private final byte[] ki;
    private final boolean useCounter;
    private final int r;
    private final byte[] fixedInputData;
    private final int counterLocation;

    private KDFDoublePipelineIterationParameters(int n2, byte[] byArray, byte[] byArray2, int n3, boolean bl2) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.counterLocation = n2;
        this.ki = Arrays.clone(byArray);
        this.fixedInputData = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        if (n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.r = n3;
        this.useCounter = bl2;
    }

    public static KDFDoublePipelineIterationParameters createWithCounter(int n2, byte[] byArray, byte[] byArray2, int n3) {
        return new KDFDoublePipelineIterationParameters(n2, byArray, byArray2, n3, true);
    }

    public static KDFDoublePipelineIterationParameters createWithoutCounter(byte[] byArray, byte[] byArray2) {
        return new KDFDoublePipelineIterationParameters(0, byArray, byArray2, 32, false);
    }

    public int getCounterLocation() {
        return this.counterLocation;
    }

    public byte[] getKI() {
        return this.ki;
    }

    public boolean useCounter() {
        return this.useCounter;
    }

    public int getR() {
        return this.r;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }
}

