/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.StreamCipher;

public abstract class StreamBlockCipher
implements BlockCipher,
StreamCipher {
    private final BlockCipher cipher;

    public StreamBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public final byte returnByte(byte by2) {
        return this.calculateByte(by2);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (n4 + n3 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        int n5 = n2;
        int n6 = n2 + n3;
        int n7 = n4;
        while (n5 < n6) {
            byArray2[n7++] = this.calculateByte(byArray[n5++]);
        }
        return n3;
    }

    protected abstract byte calculateByte(byte var1);
}

