/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralAuthParameters<T extends GeneralAuthParameters>
extends GeneralParametersWithIV<T>
implements AuthenticationParametersWithIV<T> {
    protected final int macLenInBits;

    protected GeneralAuthParameters(GeneralAlgorithm generalAlgorithm, int n2, byte[] byArray, int n3) {
        super(generalAlgorithm, n2, byArray);
        this.macLenInBits = n3;
    }

    @Override
    public int getMACSizeInBits() {
        return this.macLenInBits;
    }

    @Override
    public T withIV(SecureRandom secureRandom, int n2) {
        return (T)this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createIvIfNecessary(n2, secureRandom));
    }

    @Override
    public T withMACSize(int n2) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), this.getIV(), n2);
    }

    @Override
    protected T create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
        return this.create(generalAlgorithm, byArray, this.getMACSizeInBits());
    }

    abstract T create(GeneralAlgorithm var1, byte[] var2, int var3);
}

