/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Agreement;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.general.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.general.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.general.Ed25519Signer;
import org.bouncycastle.crypto.general.Ed448KeyPairGenerator;
import org.bouncycastle.crypto.general.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.general.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.general.Ed448Signer;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.X25519Agreement;
import org.bouncycastle.crypto.general.X25519KeyPairGenerator;
import org.bouncycastle.crypto.general.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.general.X25519PublicKeyParameters;
import org.bouncycastle.crypto.general.X448Agreement;
import org.bouncycastle.crypto.general.X448KeyPairGenerator;
import org.bouncycastle.crypto.general.X448PrivateKeyParameters;
import org.bouncycastle.crypto.general.X448PublicKeyParameters;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.RawAgreement;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.SignerOutputStream;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.math.ec.rfc7748.X448;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class EdEC {
    public static final byte[] ZERO_CONTEXT = new byte[0];
    public static final Parameters EdDSA = new Parameters(null);
    public static final Parameters Ed448 = new Parameters(Algorithm.Ed448);
    public static final Parameters Ed25519 = new Parameters(Algorithm.Ed25519);
    public static final Parameters X448 = new Parameters(Algorithm.X448);
    public static final Parameters X25519 = new Parameters(Algorithm.X25519);
    public static final int X448_PUBLIC_KEY_SIZE = 56;
    public static final int X25519_PUBLIC_KEY_SIZE = 32;
    public static final int Ed448_PUBLIC_KEY_SIZE = 57;
    public static final int Ed25519_PUBLIC_KEY_SIZE = 32;
    public static final int X448_PRIVATE_KEY_SIZE = 56;
    public static final int X25519_PRIVATE_KEY_SIZE = 32;
    public static final int Ed448_PRIVATE_KEY_SIZE = 57;
    public static final int Ed25519_PRIVATE_KEY_SIZE = 32;
    private static final byte[] x448Secret = Hex.decode("683ea9b2857ff88fff5160bede45edb3b64f5d76c2c3ef6ef0479caa65c6ec2bcddaf76e3c3c61dcc557a09771b7593cf6240c2328b4054f");
    private static final byte[] x448Public = Hex.decode("daafe9ae6984c3ab2fea0498990ee3c1690aac801e508a735e037436dcd16435c5fa93b5186e668247c4c1e9560a3d2e53a1136ca714978b");
    private static final byte[] x25519Secret = Hex.decode("4a434deaa453db96d893c92d4193d5ccb0002e74121548f936c2a313b9fd3a49");
    private static final byte[] x25519Public = Hex.decode("722143ed71a72fb2f6ecb3a2549d09d0e9db308b79450c38cd2d406ef8723167");
    private static final byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");

    private EdEC() {
    }

    public static byte[] computePublicData(org.bouncycastle.crypto.Algorithm algorithm, byte[] byArray) {
        byte[] byArray2;
        if (algorithm.equals(Algorithm.Ed448)) {
            Ed448 ed448 = new Ed448(){

                public Xof createXof() {
                    return (Xof)Register.createDigest(FipsSHS.Algorithm.SHAKE256);
                }
            };
            byArray2 = new byte[57];
            ed448.generatePublicKey(byArray, 0, byArray2, 0);
        } else if (algorithm.equals(Algorithm.Ed25519)) {
            Ed25519 ed25519 = new Ed25519(){

                public Digest createDigest() {
                    return Register.createDigest(FipsSHS.Algorithm.SHA512);
                }
            };
            byArray2 = new byte[32];
            ed25519.generatePublicKey(byArray, 0, byArray2, 0);
        } else if (algorithm.equals(Algorithm.X448)) {
            byArray2 = new byte[56];
            org.bouncycastle.math.ec.rfc7748.X448.scalarMultBase(byArray, 0, byArray2, 0);
        } else {
            byArray2 = new byte[32];
            org.bouncycastle.math.ec.rfc7748.X25519.scalarMultBase(byArray, 0, byArray2, 0);
        }
        return byArray2;
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricEdDSAPrivateKey.getAlgorithm().equals(Algorithm.Ed448)) {
                    return new Ed448PrivateKeyParameters(asymmetricEdDSAPrivateKey.getSecret(), 0);
                }
                return new Ed25519PrivateKeyParameters(asymmetricEdDSAPrivateKey.getSecret(), 0);
            }
        });
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricEdDSAPublicKey.getAlgorithm().equals(Algorithm.Ed448)) {
                    return new Ed448PublicKeyParameters(asymmetricEdDSAPublicKey.getPublicData(), 0);
                }
                return new Ed25519PublicKeyParameters(asymmetricEdDSAPublicKey.getPublicData(), 0);
            }
        });
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricXDHPrivateKey asymmetricXDHPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricXDHPrivateKey.getAlgorithm().equals(Algorithm.X448)) {
                    return new X448PrivateKeyParameters(asymmetricXDHPrivateKey.getSecret(), 0);
                }
                return new X25519PrivateKeyParameters(asymmetricXDHPrivateKey.getSecret(), 0);
            }
        });
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricXDHPublicKey asymmetricXDHPublicKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                if (asymmetricXDHPublicKey.getAlgorithm().equals(Algorithm.X448)) {
                    return new X448PublicKeyParameters(asymmetricXDHPublicKey.getPublicData(), 0);
                }
                return new X25519PublicKeyParameters(asymmetricXDHPublicKey.getPublicData(), 0);
            }
        });
    }

    private static void validateAgreementKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        if (asymmetricCipherKeyPair.getPublic() instanceof X448PublicKeyParameters) {
            SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)Algorithm.X448, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return EdEC.isOkayAgreeing(new X448Agreement(), asymmetricCipherKeyPair, new X448PrivateKeyParameters(x448Secret, 0), new X448PublicKeyParameters(x448Public, 0));
                }
            });
        } else {
            SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)Algorithm.X25519, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return EdEC.isOkayAgreeing(new X25519Agreement(), asymmetricCipherKeyPair, new X25519PrivateKeyParameters(x25519Secret, 0), new X25519PublicKeyParameters(x25519Public, 0));
                }
            });
        }
    }

    private static boolean isOkayAgreeing(RawAgreement rawAgreement, AsymmetricCipherKeyPair asymmetricCipherKeyPair, CipherParameters cipherParameters, CipherParameters cipherParameters2) {
        try {
            byte[] byArray = new byte[rawAgreement.getAgreementSize()];
            byte[] byArray2 = new byte[rawAgreement.getAgreementSize()];
            rawAgreement.init(asymmetricCipherKeyPair.getPrivate());
            rawAgreement.calculateAgreement(cipherParameters2, byArray, 0);
            rawAgreement.init(cipherParameters);
            rawAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic(), byArray2, 0);
            return Arrays.areEqual(byArray, byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void validateSigningKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        if (asymmetricCipherKeyPair.getPublic() instanceof Ed448PublicKeyParameters) {
            SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)Algorithm.Ed448, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return EdEC.isOkaySigning(new Ed448Signer(ZERO_CONTEXT), asymmetricCipherKeyPair);
                }
            });
        } else {
            SelfTestExecutor.validate((org.bouncycastle.crypto.Algorithm)Algorithm.Ed25519, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

                @Override
                public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                    return EdEC.isOkaySigning(new Ed25519Signer(), asymmetricCipherKeyPair);
                }
            });
        }
    }

    private static boolean isOkaySigning(Signer signer, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        try {
            signer.init(true, asymmetricCipherKeyPair.getPrivate());
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            signer.init(false, asymmetricCipherKeyPair.getPublic());
            signer.update(data, 0, data.length);
            return signer.verifySignature(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final class Algorithm {
        public static final GeneralAlgorithm Ed448 = new GeneralAlgorithm("Ed448", (Enum)Variations.Ed448);
        public static final GeneralAlgorithm Ed25519 = new GeneralAlgorithm("Ed25519", (Enum)Variations.Ed25519);
        public static final GeneralAlgorithm X448 = new GeneralAlgorithm("X448", (Enum)Variations.X448);
        public static final GeneralAlgorithm X25519 = new GeneralAlgorithm("X25519", (Enum)Variations.X25519);

        private Algorithm() {
        }
    }

    public static final class EdDSAKeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator {
        private final Variations variation;
        private final AsymmetricCipherKeyPairGenerator kpGen;

        public EdDSAKeyPairGenerator(Parameters parameters, SecureRandom secureRandom) {
            super(parameters);
            switch ((Variations)((GeneralAlgorithm)parameters.getAlgorithm()).basicVariation()) {
                case Ed448: {
                    this.variation = Variations.Ed448;
                    this.kpGen = new Ed448KeyPairGenerator();
                    break;
                }
                case Ed25519: {
                    this.variation = Variations.Ed25519;
                    this.kpGen = new Ed25519KeyPairGenerator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            this.kpGen.init(new KeyGenerationParameters(secureRandom, 0));
        }

        protected AsymmetricKeyPair doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpGen.generateKeyPair();
            EdEC.validateSigningKeyPair(asymmetricCipherKeyPair);
            switch (this.variation) {
                case Ed448: {
                    return new AsymmetricKeyPair<AsymmetricEdDSAPublicKey, AsymmetricEdDSAPrivateKey>(new AsymmetricEdDSAPublicKey(this.getParameters().getAlgorithm(), ((Ed448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricEdDSAPrivateKey(this.getParameters().getAlgorithm(), ((Ed448PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((Ed448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
                case Ed25519: {
                    return new AsymmetricKeyPair<AsymmetricEdDSAPublicKey, AsymmetricEdDSAPrivateKey>(new AsymmetricEdDSAPublicKey(this.getParameters().getAlgorithm(), ((Ed25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricEdDSAPrivateKey(this.getParameters().getAlgorithm(), ((Ed25519PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((Ed25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
            }
            throw new IllegalArgumentException("unknown algorithm");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EdDSAOperatorFactory
    extends GuardedSignatureOperatorFactory<Parameters> {
        @Override
        protected OutputSigner<Parameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, final Parameters parameters) {
            Signer signer;
            final GeneralAlgorithm generalAlgorithm = parameters.getAlgorithm() != null ? (GeneralAlgorithm)parameters.getAlgorithm() : (GeneralAlgorithm)asymmetricPrivateKey.getAlgorithm();
            switch ((Variations)generalAlgorithm.basicVariation()) {
                case Ed448: {
                    signer = new Ed448Signer(ZERO_CONTEXT);
                    signer.init(true, EdEC.getLwKey((AsymmetricEdDSAPrivateKey)asymmetricPrivateKey));
                    break;
                }
                case Ed25519: {
                    signer = new Ed25519Signer();
                    signer.init(true, EdEC.getLwKey((AsymmetricEdDSAPrivateKey)asymmetricPrivateKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            return new OutputSigner<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getSigningStream() {
                    return new SignerOutputStream(generalAlgorithm.getName(), signer);
                }

                @Override
                public byte[] getSignature() throws PlainInputProcessingException {
                    try {
                        return signer.generateSignature();
                    }
                    catch (Exception exception) {
                        throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
                    }
                }

                @Override
                public int getSignature(byte[] byArray, int n2) throws PlainInputProcessingException {
                    byte[] byArray2 = this.getSignature();
                    System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                    return byArray2.length;
                }
            };
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, final Parameters parameters) {
            Signer signer;
            final GeneralAlgorithm generalAlgorithm = parameters.getAlgorithm() != null ? (GeneralAlgorithm)parameters.getAlgorithm() : (GeneralAlgorithm)asymmetricPublicKey.getAlgorithm();
            switch ((Variations)generalAlgorithm.basicVariation()) {
                case Ed448: {
                    signer = new Ed448Signer(new byte[0]);
                    signer.init(false, EdEC.getLwKey((AsymmetricEdDSAPublicKey)asymmetricPublicKey));
                    break;
                }
                case Ed25519: {
                    signer = new Ed25519Signer();
                    signer.init(false, EdEC.getLwKey((AsymmetricEdDSAPublicKey)asymmetricPublicKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            return new OutputVerifier<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(generalAlgorithm.getName(), signer);
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    return signer.verifySignature(byArray);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        Ed448,
        Ed25519,
        X448,
        X25519;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class XDHAgreementFactory
    implements AgreementFactory<Parameters> {
        public XDHAgreementFactory() {
            FipsStatus.isReady();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
            }
        }

        @Override
        public Agreement<Parameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, final Parameters parameters) {
            RawAgreement rawAgreement;
            switch ((Variations)((GeneralAlgorithm)parameters.getAlgorithm()).basicVariation()) {
                case X448: {
                    rawAgreement = new X448Agreement();
                    rawAgreement.init(EdEC.getLwKey((AsymmetricXDHPrivateKey)asymmetricPrivateKey));
                    break;
                }
                case X25519: {
                    rawAgreement = new X25519Agreement();
                    rawAgreement.init(EdEC.getLwKey((AsymmetricXDHPrivateKey)asymmetricPrivateKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            return new Agreement<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
                    AsymmetricKeyParameter asymmetricKeyParameter = EdEC.getLwKey((AsymmetricXDHPublicKey)asymmetricPublicKey);
                    byte[] byArray = asymmetricKeyParameter instanceof X448PublicKeyParameters ? new byte[56] : new byte[32];
                    rawAgreement.calculateAgreement(asymmetricKeyParameter, byArray, 0);
                    return byArray;
                }
            };
        }
    }

    public static final class XDHKeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator {
        private final Variations variation;
        private final AsymmetricCipherKeyPairGenerator kpGen;

        public XDHKeyPairGenerator(Parameters parameters, SecureRandom secureRandom) {
            super(parameters);
            switch ((Variations)((GeneralAlgorithm)parameters.getAlgorithm()).basicVariation()) {
                case X448: {
                    this.variation = Variations.X448;
                    this.kpGen = new X448KeyPairGenerator();
                    break;
                }
                case X25519: {
                    this.variation = Variations.X25519;
                    this.kpGen = new X25519KeyPairGenerator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown algorithm");
                }
            }
            this.kpGen.init(new KeyGenerationParameters(secureRandom, 0));
        }

        protected AsymmetricKeyPair doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpGen.generateKeyPair();
            EdEC.validateAgreementKeyPair(asymmetricCipherKeyPair);
            switch (this.variation) {
                case X448: {
                    return new AsymmetricKeyPair<AsymmetricXDHPublicKey, AsymmetricXDHPrivateKey>(new AsymmetricXDHPublicKey(this.getParameters().getAlgorithm(), ((X448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricXDHPrivateKey(this.getParameters().getAlgorithm(), ((X448PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((X448PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
                case X25519: {
                    return new AsymmetricKeyPair<AsymmetricXDHPublicKey, AsymmetricXDHPrivateKey>(new AsymmetricXDHPublicKey(this.getParameters().getAlgorithm(), ((X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()), new AsymmetricXDHPrivateKey(this.getParameters().getAlgorithm(), ((X25519PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getEncoded(), ((X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getEncoded()));
                }
            }
            throw new IllegalArgumentException("unknown algorithm");
        }
    }
}

