/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.general.DesEdeWrapEngine;
import org.bouncycastle.crypto.general.GOST28147Mac;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.ISO9797Alg3Mac;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.RC2;
import org.bouncycastle.crypto.general.RC2WrapEngine;
import org.bouncycastle.crypto.general.RFC3211WrapEngine;
import org.bouncycastle.crypto.general.TripleDES;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.macs.AEADCipherMac;
import org.bouncycastle.crypto.internal.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.internal.macs.CFBBlockCipherMac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.GMac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CBCBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.CFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.EAXBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.internal.modes.OCBBlockCipher;
import org.bouncycastle.crypto.internal.modes.OFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import org.bouncycastle.crypto.internal.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.internal.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.internal.paddings.PKCS7Padding;
import org.bouncycastle.crypto.internal.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.internal.paddings.TBCPadding;
import org.bouncycastle.crypto.internal.paddings.X923Padding;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapWithPaddingEngine;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CipherUtils {
    private static SecureRandom defaultRandomPadder;

    CipherUtils() {
    }

    static BufferedBlockCipher createBlockCipher(EngineProvider<BlockCipher> engineProvider, Parameters parameters) {
        GeneralAlgorithm generalAlgorithm = (GeneralAlgorithm)parameters.getAlgorithm();
        BlockCipher blockCipher = engineProvider.createEngine();
        Padding padding = (Padding)generalAlgorithm.additionalVariation();
        switch ((Mode)generalAlgorithm.basicVariation()) {
            case ECB: {
                break;
            }
            case CBC: {
                if (padding == Padding.CS1 || padding == Padding.CS2 || padding == Padding.CS3) break;
                blockCipher = new CBCBlockCipher(blockCipher);
                break;
            }
            case CFB8: {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                break;
            }
            case CFB64: {
                blockCipher = new CFBBlockCipher(blockCipher, 64);
                break;
            }
            case CFB128: {
                blockCipher = new CFBBlockCipher(blockCipher, 128);
                break;
            }
            case CFB256: {
                blockCipher = new CFBBlockCipher(blockCipher, 256);
                break;
            }
            case OFB64: {
                blockCipher = new OFBBlockCipher(blockCipher, 64);
                break;
            }
            case OFB128: {
                blockCipher = new OFBBlockCipher(blockCipher, 128);
                break;
            }
            case OFB256: {
                blockCipher = new OFBBlockCipher(blockCipher, 256);
                break;
            }
            case CTR: {
                blockCipher = new SICBlockCipher(blockCipher);
                break;
            }
            case OpenPGPCFB: {
                blockCipher = new OpenPGPCFBBlockCipher(blockCipher);
                break;
            }
            case GCFB: {
                blockCipher = new GCFBBlockCipher(blockCipher);
                break;
            }
            case GOFB: {
                blockCipher = new GOFBBlockCipher(blockCipher);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createBlockCipher: " + generalAlgorithm.getName());
            }
        }
        if (padding != null) {
            switch (padding) {
                case PKCS7: {
                    return new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
                }
                case ISO7816_4: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO7816d4Padding());
                }
                case ISO10126_2: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO10126d2Padding());
                }
                case TBC: {
                    return new PaddedBufferedBlockCipher(blockCipher, new TBCPadding());
                }
                case X923: {
                    return new PaddedBufferedBlockCipher(blockCipher, new X923Padding());
                }
                case CS1: {
                    return new NISTCTSBlockCipher(1, blockCipher);
                }
                case CS2: {
                    return new NISTCTSBlockCipher(2, blockCipher);
                }
                case CS3: {
                    return new NISTCTSBlockCipher(3, blockCipher);
                }
            }
            throw new IllegalArgumentException("Unknown padding passed to createBlockCipher: " + parameters.getAlgorithm());
        }
        return new BufferedBlockCipher(blockCipher);
    }

    static BufferedBlockCipher createStandardCipher(boolean bl2, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, SecureRandom secureRandom) {
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
        return CipherUtils.createStandardCipher(bl2, keyParameterImpl, engineProvider, parametersWithIV, secureRandom);
    }

    static BufferedBlockCipher createStandardCipher(boolean bl2, KeyParameter keyParameter, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, SecureRandom secureRandom) {
        Padding padding;
        BufferedBlockCipher bufferedBlockCipher = CipherUtils.createBlockCipher(engineProvider, parametersWithIV);
        CipherParameters cipherParameters = keyParameter;
        if (parametersWithIV.getIV() != null) {
            cipherParameters = new org.bouncycastle.crypto.internal.params.ParametersWithIV(cipherParameters, parametersWithIV.getIV());
        }
        if (((GeneralAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation() instanceof Padding && (padding = (Padding)((GeneralAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation()).getBasePadding().requiresRandom() && bl2) {
            if (secureRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
            } else {
                try {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CryptoServicesRegistrar.getSecureRandom());
                }
                catch (IllegalStateException illegalStateException) {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CipherUtils.getDefaultRandomPadder());
                }
            }
        }
        bufferedBlockCipher.init(bl2, cipherParameters);
        return bufferedBlockCipher;
    }

    static AEADBlockCipher createAEADCipher(GeneralAlgorithm generalAlgorithm, EngineProvider<BlockCipher> engineProvider) {
        AEADBlockCipher aEADBlockCipher;
        switch ((Mode)generalAlgorithm.basicVariation()) {
            case CCM: {
                aEADBlockCipher = new CCMBlockCipher(engineProvider.createEngine());
                break;
            }
            case EAX: {
                aEADBlockCipher = new EAXBlockCipher(engineProvider.createEngine());
                break;
            }
            case GCM: {
                aEADBlockCipher = new GCMBlockCipher(engineProvider.createEngine());
                break;
            }
            case OCB: {
                aEADBlockCipher = new OCBBlockCipher(engineProvider.createEngine(), engineProvider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createAEADCipher: " + generalAlgorithm.getName());
            }
        }
        return aEADBlockCipher;
    }

    static AEADBlockCipher createStandardAEADCipher(boolean bl2, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, AuthenticationParametersWithIV authenticationParametersWithIV) {
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
        return CipherUtils.createStandardAEADCipher(bl2, keyParameterImpl, engineProvider, authenticationParametersWithIV);
    }

    static AEADBlockCipher createStandardAEADCipher(boolean bl2, KeyParameter keyParameter, EngineProvider<BlockCipher> engineProvider, AuthenticationParametersWithIV authenticationParametersWithIV) {
        AEADBlockCipher aEADBlockCipher = CipherUtils.createAEADCipher((GeneralAlgorithm)authenticationParametersWithIV.getAlgorithm(), engineProvider);
        if (authenticationParametersWithIV.getIV() != null) {
            aEADBlockCipher.init(bl2, new AEADParameters(keyParameter, authenticationParametersWithIV.getMACSizeInBits(), authenticationParametersWithIV.getIV()));
        } else {
            aEADBlockCipher.init(bl2, keyParameter);
        }
        return aEADBlockCipher;
    }

    static Mac createStandardMac(ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, GeneralAuthParameters generalAuthParameters) {
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
        return CipherUtils.createStandardMac(keyParameterImpl, engineProvider, generalAuthParameters);
    }

    static Mac createStandardMac(KeyParameter keyParameter, EngineProvider<BlockCipher> engineProvider, GeneralAuthParameters generalAuthParameters) {
        Mac mac = CipherUtils.getMac(generalAuthParameters, engineProvider);
        if (generalAuthParameters.getIV() != null) {
            mac.init(new org.bouncycastle.crypto.internal.params.ParametersWithIV(keyParameter, generalAuthParameters.getIV()));
        } else {
            mac.init(keyParameter);
        }
        return mac;
    }

    private static Mac getMac(AuthenticationParameters authenticationParameters, EngineProvider<BlockCipher> engineProvider) {
        Mac mac;
        Padding padding = (Padding)((GeneralAlgorithm)authenticationParameters.getAlgorithm()).additionalVariation();
        switch ((Mode)((GeneralAlgorithm)authenticationParameters.getAlgorithm()).basicVariation()) {
            case CBCMAC: {
                if (padding != null) {
                    if (padding == Padding.ISO7816_4) {
                        mac = new CBCBlockCipherMac(engineProvider.createEngine(), authenticationParameters.getMACSizeInBits(), new ISO7816d4Padding());
                        break;
                    }
                    throw new IllegalArgumentException("Unknown padding passed to MAC operator factory: " + authenticationParameters.getAlgorithm().getName());
                }
                mac = new CBCBlockCipherMac(engineProvider.createEngine(), authenticationParameters.getMACSizeInBits());
                break;
            }
            case CCM: {
                mac = new AEADCipherMac(new CCMBlockCipher(engineProvider.createEngine()), authenticationParameters.getMACSizeInBits());
                break;
            }
            case CMAC: {
                mac = new CMac(engineProvider.createEngine(), authenticationParameters.getMACSizeInBits());
                break;
            }
            case GMAC: {
                mac = new GMac(new GCMBlockCipher(engineProvider.createEngine()), authenticationParameters.getMACSizeInBits());
                break;
            }
            case CFB8MAC: {
                mac = new CFBBlockCipherMac(engineProvider.createEngine());
                break;
            }
            case GOSTMAC: {
                mac = new GOST28147Mac();
                break;
            }
            case ISO9797alg3: {
                if (padding != null) {
                    if (padding == Padding.ISO7816_4) {
                        mac = new ISO9797Alg3Mac(engineProvider.createEngine(), authenticationParameters.getMACSizeInBits(), new ISO7816d4Padding());
                        break;
                    }
                    throw new IllegalArgumentException("Unknown padding passed to MAC operator factory: " + authenticationParameters.getAlgorithm().getName());
                }
                mac = new ISO9797Alg3Mac(engineProvider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to MAC operator factory: " + authenticationParameters.getAlgorithm().getName());
            }
        }
        return mac;
    }

    static Wrapper createStandardWrapper(boolean bl2, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, SecureRandom secureRandom) {
        return CipherUtils.createStandardWrapper(bl2, new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), engineProvider, parametersWithIV, false, secureRandom);
    }

    static Wrapper createStandardWrapper(boolean bl2, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, boolean bl3, SecureRandom secureRandom) {
        return CipherUtils.createStandardWrapper(bl2, new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), engineProvider, parametersWithIV, bl3, secureRandom);
    }

    static Wrapper createStandardWrapper(boolean bl2, KeyParameter keyParameter, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, boolean bl3, SecureRandom secureRandom) {
        Wrapper wrapper;
        GeneralAlgorithm generalAlgorithm = (GeneralAlgorithm)parametersWithIV.getAlgorithm();
        boolean bl4 = false;
        switch ((Mode)generalAlgorithm.basicVariation()) {
            case WRAP: {
                wrapper = new SP80038FWrapEngine(engineProvider.createEngine(), bl3);
                break;
            }
            case WRAPPAD: {
                wrapper = new SP80038FWrapWithPaddingEngine(engineProvider.createEngine(), bl3);
                break;
            }
            case RFC3211_WRAP: {
                bl4 = true;
                wrapper = new RFC3211WrapEngine(engineProvider.createEngine());
                break;
            }
            case RFC3217_WRAP: {
                bl4 = true;
                if (generalAlgorithm.equals(TripleDES.RFC3217_WRAP.getAlgorithm())) {
                    wrapper = new DesEdeWrapEngine();
                    break;
                }
                if (generalAlgorithm.equals(RC2.RFC3217_WRAP.getAlgorithm())) {
                    wrapper = new RC2WrapEngine();
                    break;
                }
                throw new IllegalArgumentException("Unknown RFC3217 algorithm passed to Key Wrap operator factory: " + generalAlgorithm.getName());
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to Key Wrap operator factory: " + generalAlgorithm.getName());
            }
        }
        CipherParameters cipherParameters = keyParameter;
        if (parametersWithIV.getIV() != null) {
            cipherParameters = new org.bouncycastle.crypto.internal.params.ParametersWithIV(keyParameter, parametersWithIV.getIV());
        }
        if (bl2 && bl4) {
            if (secureRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
            } else {
                throw new IllegalArgumentException("No SecureRandom provided when one required");
            }
        }
        wrapper.init(bl2, cipherParameters);
        return wrapper;
    }

    static synchronized SecureRandom getDefaultRandomPadder() {
        if (defaultRandomPadder == null) {
            defaultRandomPadder = FipsDRBG.SHA512.fromDefaultEntropy().setPersonalizationString(Strings.toByteArray("Bouncy Castle General Default Padder")).build(Pack.longToBigEndian(System.currentTimeMillis()), false);
        }
        return defaultRandomPadder;
    }
}

