/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.EcMqvBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.util.BigIntegers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EcDHAgreement<T extends FipsAgreementParameters>
extends FipsAgreement<T> {
    private final BasicAgreement dh;
    private final T parameter;

    EcDHAgreement(BasicAgreement basicAgreement, T t2) {
        this.dh = basicAgreement;
        this.parameter = t2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public byte[] calculate(AsymmetricPublicKey asymmetricPublicKey) {
        BigInteger bigInteger;
        Object object;
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EcDHAgreement.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
        int n2 = this.dh.getFieldSize();
        if (this.dh instanceof EcMqvBasicAgreement) {
            object = ((FipsEC.MQVAgreementParameters)this.parameter).getOtherPartyEphemeralKey();
            bigInteger = this.dh.calculateAgreement(new EcMqvPublicParameters(ecPublicKeyParameters, new EcPublicKeyParameters(((AsymmetricECPublicKey)object).getW(), EcDHAgreement.getDomainParams(((AsymmetricECKey)object).getDomainParameters()))));
        } else {
            bigInteger = this.dh.calculateAgreement(ecPublicKeyParameters);
        }
        object = BigIntegers.asUnsignedByteArray(n2, bigInteger);
        return FipsKDF.processZBytes((byte[])object, this.parameter);
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }
}

