/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.util.encoders;

public class UTF8 {
    private static final byte C_ILL = 0;
    private static final byte C_CR1 = 1;
    private static final byte C_CR2 = 2;
    private static final byte C_CR3 = 3;
    private static final byte C_L2A = 4;
    private static final byte C_L3A = 5;
    private static final byte C_L3B = 6;
    private static final byte C_L3C = 7;
    private static final byte C_L4A = 8;
    private static final byte C_L4B = 9;
    private static final byte C_L4C = 10;
    private static final byte S_ERR = -2;
    private static final byte S_END = -1;
    private static final byte S_CS1 = 0;
    private static final byte S_CS2 = 16;
    private static final byte S_CS3 = 32;
    private static final byte S_P3A = 48;
    private static final byte S_P3B = 64;
    private static final byte S_P4A = 80;
    private static final byte S_P4B = 96;
    private static final short[] firstUnitTable = new short[128];
    private static final byte[] transitionTable = new byte[112];

    private static void fill(byte[] byArray, int n2, int n3, byte by2) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            byArray[i2] = by2;
        }
    }

    public static int transcodeToUTF16(byte[] byArray, char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            byte by2;
            if ((by2 = byArray[n2++]) >= 0) {
                if (n3 >= cArray.length) {
                    return -1;
                }
                cArray[n3++] = (char)by2;
                continue;
            }
            short s2 = firstUnitTable[by2 & 0x7F];
            int n4 = s2 >>> 8;
            byte by3 = (byte)s2;
            while (by3 >= 0) {
                if (n2 >= byArray.length) {
                    return -1;
                }
                by2 = byArray[n2++];
                n4 = n4 << 6 | by2 & 0x3F;
                by3 = transitionTable[by3 + ((by2 & 0xFF) >>> 4)];
            }
            if (by3 == -2) {
                return -1;
            }
            if (n4 <= 65535) {
                if (n3 >= cArray.length) {
                    return -1;
                }
                cArray[n3++] = (char)n4;
                continue;
            }
            if (n3 >= cArray.length - 1) {
                return -1;
            }
            cArray[n3++] = (char)(55232 + (n4 >>> 10));
            cArray[n3++] = (char)(0xDC00 | n4 & 0x3FF);
        }
        return n3;
    }

    static {
        byte[] byArray = new byte[128];
        UTF8.fill(byArray, 0, 15, (byte)1);
        UTF8.fill(byArray, 16, 31, (byte)2);
        UTF8.fill(byArray, 32, 63, (byte)3);
        UTF8.fill(byArray, 64, 65, (byte)0);
        UTF8.fill(byArray, 66, 95, (byte)4);
        UTF8.fill(byArray, 96, 96, (byte)5);
        UTF8.fill(byArray, 97, 108, (byte)6);
        UTF8.fill(byArray, 109, 109, (byte)7);
        UTF8.fill(byArray, 110, 111, (byte)6);
        UTF8.fill(byArray, 112, 112, (byte)8);
        UTF8.fill(byArray, 113, 115, (byte)9);
        UTF8.fill(byArray, 116, 116, (byte)10);
        UTF8.fill(byArray, 117, 127, (byte)0);
        UTF8.fill(transitionTable, 0, transitionTable.length - 1, (byte)-2);
        UTF8.fill(transitionTable, 8, 11, (byte)-1);
        UTF8.fill(transitionTable, 24, 27, (byte)0);
        UTF8.fill(transitionTable, 40, 43, (byte)16);
        UTF8.fill(transitionTable, 58, 59, (byte)0);
        UTF8.fill(transitionTable, 72, 73, (byte)0);
        UTF8.fill(transitionTable, 89, 91, (byte)16);
        UTF8.fill(transitionTable, 104, 104, (byte)16);
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 31, 15, 15, 15, 7, 7, 7};
        byte[] byArray3 = new byte[]{-2, -2, -2, -2, 0, 48, 16, 64, 80, 32, 96};
        for (int i2 = 0; i2 < 128; ++i2) {
            byte by2 = byArray[i2];
            int n2 = i2 & byArray2[by2];
            byte by3 = byArray3[by2];
            UTF8.firstUnitTable[i2] = (short)(n2 << 8 | by3);
        }
    }
}

