/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.mime;

import com.aspose.html.utils.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.InputStream;

public class BoundaryLimitedInputStream
extends InputStream {
    private final InputStream src;
    private final byte[] boundary;
    private final byte[] buf;
    private int bufOff = 0;
    private int index = 0;
    private boolean ended = false;
    private int lastI;

    public BoundaryLimitedInputStream(InputStream inputStream, String string) {
        this.src = inputStream;
        this.boundary = Strings.toByteArray(string);
        this.buf = new byte[string.length() + 3];
        this.bufOff = 0;
    }

    public int read() throws IOException {
        int n2;
        if (this.ended) {
            return -1;
        }
        if (this.index < this.bufOff) {
            n2 = this.buf[this.index++] & 0xFF;
            if (this.index < this.bufOff) {
                return n2;
            }
            this.bufOff = 0;
            this.index = 0;
        } else {
            n2 = this.src.read();
        }
        this.lastI = n2;
        if (n2 < 0) {
            return -1;
        }
        if (n2 == 13 || n2 == 10) {
            int n3;
            this.index = 0;
            if (n2 == 13) {
                n3 = this.src.read();
                if (n3 == 10) {
                    this.buf[this.bufOff++] = 10;
                    n3 = this.src.read();
                }
            } else {
                n3 = this.src.read();
            }
            if (n3 == 45) {
                this.buf[this.bufOff++] = 45;
                n3 = this.src.read();
            }
            if (n3 == 45) {
                int n4;
                this.buf[this.bufOff++] = 45;
                int n5 = this.bufOff;
                while (this.bufOff - n5 != this.boundary.length && (n4 = this.src.read()) >= 0) {
                    this.buf[this.bufOff] = (byte)n4;
                    if (this.buf[this.bufOff] != this.boundary[this.bufOff - n5]) {
                        ++this.bufOff;
                        break;
                    }
                    ++this.bufOff;
                }
                if (this.bufOff - n5 == this.boundary.length) {
                    this.ended = true;
                    return -1;
                }
            } else if (n3 >= 0) {
                this.buf[this.bufOff++] = (byte)n3;
            }
        }
        return n2;
    }
}

