/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.spec;

import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsKDF;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.KTSKeySpec;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class KTSParameterSpec
implements AlgorithmParameterSpec {
    public static final FipsKDF.AgreementKDFParametersBuilder KDF2 = FipsKDF.X963;
    public static final FipsKDF.AgreementKDFParametersBuilder KDF3 = FipsKDF.CONCATENATION;
    private final String wrappingKeyAlgorithm;
    private final int keySizeInBits;
    private final AlgorithmParameterSpec parameterSpec;
    private final AlgorithmIdentifier kdfAlgorithm;
    private byte[] otherInfo;

    private KTSParameterSpec(String string, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.wrappingKeyAlgorithm = string;
        this.keySizeInBits = n2;
        this.parameterSpec = algorithmParameterSpec;
        this.kdfAlgorithm = algorithmIdentifier;
        this.otherInfo = byArray;
    }

    public String getKeyAlgorithmName() {
        return this.wrappingKeyAlgorithm;
    }

    public int getKeySize() {
        return this.keySizeInBits;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public AlgorithmIdentifier getKdfAlgorithm() {
        return this.kdfAlgorithm;
    }

    public byte[] getOtherInfo() {
        return Arrays.clone(this.otherInfo);
    }

    public static final class Builder {
        private final String algorithmName;
        private final int keySizeInBits;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;
        private byte[] otherInfo;

        public Builder(String string, int n2) {
            this(string, n2, null);
        }

        public Builder(String string, int n2, byte[] byArray) {
            this.algorithmName = string;
            this.keySizeInBits = n2;
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(byArray);
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(agreementKDFParametersBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public KTSParameterSpec build() {
            return new KTSParameterSpec(this.algorithmName, this.keySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }
    }
}

