/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.SHACAL2;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ASN1AlgorithmParameters;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.AuthParametersCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseCipher;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseMac;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GcmSpecUtil;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.IvParametersCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.SymmetricAlgorithmProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.Utils;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;

class ProvSHACAL2
extends SymmetricAlgorithmProvider {
    private static final String PREFIX = ProvSHACAL2.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvSHACAL2() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        final Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        final SHACAL2.OperatorFactory operatorFactory = new SHACAL2.OperatorFactory();
        final SHACAL2.AEADOperatorFactory aEADOperatorFactory = new SHACAL2.AEADOperatorFactory();
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SHACAL-2", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 256, SHACAL2.ECBwithPKCS7, SHACAL2.ECB, SHACAL2.ECBwithISO10126_2, SHACAL2.ECBwithISO7816_4, SHACAL2.ECBwithTBC, SHACAL2.ECBwithX923, SHACAL2.CBC, SHACAL2.CBCwithPKCS7, SHACAL2.CBCwithISO10126_2, SHACAL2.CBCwithISO7816_4, SHACAL2.CBCwithTBC, SHACAL2.CBCwithX923, SHACAL2.CBCwithCS1, SHACAL2.CBCwithCS2, SHACAL2.CBCwithCS3, SHACAL2.CFB256, SHACAL2.CFB8, SHACAL2.OFB, SHACAL2.CTR, SHACAL2.EAX).withGeneralOperators(ProvSHACAL2.this.generalParametersCreatorProvider, operatorFactory, aEADOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SHACAL-2", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "SHACAL-2", 128, false, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new SHACAL2.KeyGenerator(n2, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.SHACAL-2", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("SHACAL-2");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "SHACAL-2", "SHACAL2");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SHACAL-2CMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SHACAL2.CMAC, (MACOperatorFactory)new SHACAL2.MACOperatorFactory(), new AuthParametersCreator(SHACAL2.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SHACAL-2CMAC", "SHACAL-2-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SHACAL-2", PREFIX + "$SHACAL2KFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("SHACAL-2", SHACAL2.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n2 = byArray.length * 8;
                        if (n2 == 0 || n2 > 512 || n2 < 128 || n2 % 64 != 0) {
                            throw new InvalidKeySpecException("SHACAL-2 key must be 128 - 512 bits and a multiple of 64");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SHACAL-2", "SHACAL2");
    }
}

