/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricKeyPairGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GOST3410;
import com.aspose.html.utils.ms.core.bc.jcajce.interfaces.GOST3410PrivateKey;
import com.aspose.html.utils.ms.core.bc.jcajce.interfaces.GOST3410PublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseKeyFactory;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseSignature;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GOST3410Util;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.PrivateKeyConverter;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ProvGOST3410PrivateKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.ProvGOST3410PublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.PublicKeyConverter;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.GOST3410DomainParameterSpec;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.GOST3410ParameterSpec;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.GOST3410PrivateKeySpec;
import com.aspose.html.utils.ms.core.bc.jcajce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

class ProvGOST3410
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "com.aspose.html.utils.ms.core.bc.jcajce.provider.asymmetric.gost.";
    private static final PublicKeyConverter<AsymmetricGOST3410PublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricGOST3410PublicKey>(){

        @Override
        public AsymmetricGOST3410PublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
            if (publicKey instanceof GOST3410PublicKey) {
                if (publicKey instanceof ProvGOST3410PublicKey) {
                    return ((ProvGOST3410PublicKey)publicKey).getBaseKey();
                }
                return new ProvGOST3410PublicKey(algorithm, (GOST3410PublicKey)publicKey).getBaseKey();
            }
            try {
                return new AsymmetricGOST3410PublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify GOST3410 public key: " + exception.getMessage(), exception);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricGOST3410PrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricGOST3410PrivateKey>(){

        @Override
        public AsymmetricGOST3410PrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
            if (privateKey instanceof GOST3410PrivateKey) {
                if (privateKey instanceof ProvGOST3410PrivateKey) {
                    return ((ProvGOST3410PrivateKey)privateKey).getBaseKey();
                }
                return new ProvGOST3410PrivateKey(algorithm, (GOST3410PrivateKey)privateKey).getBaseKey();
            }
            try {
                return new AsymmetricGOST3410PrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify GOST3410 private key: " + exception.getMessage(), exception);
            }
        }
    };

    ProvGOST3410() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.GOST3410", "com.aspose.html.utils.ms.core.bc.jcajce.provider.asymmetric.gost.KeyPairGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.GOST-3410", "GOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.GOST-3410-94", "GOST3410");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.GOST3410", "com.aspose.html.utils.ms.core.bc.jcajce.provider.asymmetric.gost.KeyFactorySpi", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new GOST3410KeyFactory();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.GOST-3410", "GOST3410");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.GOST-3410-94", "GOST3410");
        this.registerOid(bouncyCastleFipsProvider, CryptoProObjectIdentifiers.gostR3410_94, "GOST3410", new GOST3410KeyFactory());
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.GOST3410", "com.aspose.html.utils.ms.core.bc.jcajce.provider.asymmetric.gost.SignatureSpi", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new GOST3410.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, GOST3410.GOST3410);
            }
        }));
        bouncyCastleFipsProvider.addAlias("Signature", "GOST3410", "GOST3411WITHGOST3410", "GOST-3410", "GOST-3410-94");
        bouncyCastleFipsProvider.addAlias("Signature", "GOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
    }

    static class GOST3410KeyFactory
    extends BaseKeyFactory {
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(GOST3410PublicKeySpec.class) && key instanceof GOST3410PublicKey) {
                GOST3410PublicKey gOST3410PublicKey = (GOST3410PublicKey)key;
                return new GOST3410PublicKeySpec(gOST3410PublicKey.getY(), gOST3410PublicKey.getParams());
            }
            if (clazz.isAssignableFrom(GOST3410PrivateKeySpec.class) && key instanceof GOST3410PrivateKey) {
                GOST3410PrivateKey gOST3410PrivateKey = (GOST3410PrivateKey)key;
                return new GOST3410PrivateKeySpec(gOST3410PrivateKey.getX(), gOST3410PrivateKey.getParams());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvGOST3410PublicKey((AsymmetricGOST3410PublicKey)publicKeyConverter.convertKey(GOST3410.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvGOST3410PrivateKey((AsymmetricGOST3410PrivateKey)privateKeyConverter.convertKey(GOST3410.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PrivateKeySpec) {
                return new ProvGOST3410PrivateKey((Algorithm)GOST3410.ALGORITHM, (GOST3410PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PublicKeySpec) {
                return new ProvGOST3410PublicKey((Algorithm)GOST3410.ALGORITHM, (GOST3410PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvGOST3410PrivateKey(new AsymmetricGOST3410PrivateKey((Algorithm)GOST3410.ALGORITHM, privateKeyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvGOST3410PublicKey(new AsymmetricGOST3410PublicKey((Algorithm)GOST3410.ALGORITHM, subjectPublicKeyInfo));
        }
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private GOST3410Parameters<GOST3410DomainParameters> params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("GOST3410");
            this.fipsProvider = bouncyCastleFipsProvider;
            this.random = bouncyCastleFipsProvider.getDefaultSecureRandom();
        }

        public void initialize(int n2) {
            this.initialize(n2, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int n2, SecureRandom secureRandom) {
            throw new InvalidParameterException("GOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec");
        }

        private void init(GOST3410ParameterSpec gOST3410ParameterSpec, SecureRandom secureRandom) {
            if (!(gOST3410ParameterSpec.getDomainParametersSpec() instanceof GOST3410DomainParameterSpec)) {
                throw new InvalidParameterException("GOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec<GOST3410DomainParameterSpec>");
            }
            this.params = GOST3410Util.convertToParams(gOST3410ParameterSpec);
            this.engine = new GOST3410.KeyPairGenerator(new GOST3410.KeyGenParameters(this.params), secureRandom);
            this.initialised = true;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            this.init((GOST3410ParameterSpec)algorithmParameterSpec, secureRandom);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(new GOST3410Parameters(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A, CryptoProObjectIdentifiers.gostR3411)), this.random);
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvGOST3410PublicKey(asymmetricGOST3410PublicKey), new ProvGOST3410PrivateKey(asymmetricGOST3410PrivateKey));
        }
    }
}

