/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.OutputSigner;
import com.aspose.html.utils.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.SignatureOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedSignatureOperatorFactory<T extends Parameters>
implements SignatureOperatorFactory<T> {
    GuardedSignatureOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputSigner<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return this.doCreateSigner(asymmetricPrivateKey, t2);
    }

    @Override
    public final OutputVerifier<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t2) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t2.getAlgorithm());
        }
        return this.doCreateVerifier(asymmetricPublicKey, t2);
    }

    protected abstract OutputSigner<T> doCreateSigner(AsymmetricPrivateKey var1, T var2);

    protected abstract OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey var1, T var2);
}

