/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

class PrivilegedUtils {
    PrivilegedUtils() {
    }

    static ValidatedSymmetricKey getValidatedKey(SymmetricKey symmetricKey) {
        return new ValidatedSymmetricKey(symmetricKey.getAlgorithm(), PrivilegedUtils.getKeyBytes(symmetricKey));
    }

    static byte[] getKeyBytes(final SymmetricKey symmetricKey) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
    }

    static void checkPermission(final Permission permission) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.checkPermission(permission);
                    return null;
                }
            });
        }
    }
}

