/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDHKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDHPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDHPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145Key;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricECKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricECPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricECPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410Key;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricRSAKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricRSAPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricRSAPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricXDHKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricXDHPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricXDHPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricKeyPair<P extends AsymmetricPublicKey, S extends AsymmetricPrivateKey> {
    private final P publicKey;
    private final S privateKey;

    public AsymmetricKeyPair(P p2, S s2) {
        AccessController.doPrivileged(new PrivilegedAction((AsymmetricPublicKey)p2, (AsymmetricPrivateKey)s2){
            final /* synthetic */ AsymmetricPublicKey val$publicKey;
            final /* synthetic */ AsymmetricPrivateKey val$privateKey;
            {
                this.val$publicKey = asymmetricPublicKey;
                this.val$privateKey = asymmetricPrivateKey;
            }

            public Object run() {
                AsymmetricKeyPair.this.checkKeyPairForConsistency(this.val$publicKey, this.val$privateKey);
                return null;
            }
        });
        this.publicKey = p2;
        this.privateKey = s2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(P p2, S s2) {
        if (p2 instanceof AsymmetricECKey && s2 instanceof AsymmetricECKey) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)s2;
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)p2;
            if (!asymmetricECPrivateKey.getDomainParameters().equals(asymmetricECPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            if (asymmetricECPrivateKey.getDomainParameters().getG().multiply(asymmetricECPrivateKey.getS()).normalize().equals(asymmetricECPublicKey.getW())) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (p2 instanceof AsymmetricDHKey && s2 instanceof AsymmetricDHKey) {
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)s2;
            AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)p2;
            DHDomainParameters dHDomainParameters = asymmetricDHPrivateKey.getDomainParameters();
            if (!dHDomainParameters.equals(asymmetricDHPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHDomainParameters.getG().modPow(asymmetricDHPrivateKey.getX(), dHDomainParameters.getP()).equals(asymmetricDHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (p2 instanceof AsymmetricDSAKey && s2 instanceof AsymmetricDSAKey) {
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)s2;
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)p2;
            DSADomainParameters dSADomainParameters = asymmetricDSAPrivateKey.getDomainParameters();
            if (!dSADomainParameters.equals(asymmetricDSAPublicKey.getDomainParameters())) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSADomainParameters.getG().modPow(asymmetricDSAPrivateKey.getX(), dSADomainParameters.getP()).equals(asymmetricDSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (p2 instanceof AsymmetricRSAKey && s2 instanceof AsymmetricRSAKey) {
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)s2;
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)p2;
            if (!asymmetricRSAPrivateKey.getModulus().equals(asymmetricRSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(asymmetricRSAPrivateKey.getPrivateExponent(), asymmetricRSAPrivateKey.getModulus()).modPow(asymmetricRSAPublicKey.getPublicExponent(), asymmetricRSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (p2 instanceof AsymmetricGOST3410Key && s2 instanceof AsymmetricGOST3410Key) {
            if (!((AsymmetricGOST3410Key)p2).getParameters().equals(((AsymmetricGOST3410Key)s2).getParameters())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (p2 instanceof AsymmetricGOST3410PublicKey && s2 instanceof AsymmetricGOST3410PrivateKey) {
                AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)s2;
                AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)p2;
                GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters = asymmetricGOST3410PrivateKey.getParameters();
                GOST3410DomainParameters gOST3410DomainParameters = gOST3410Parameters.getDomainParameters();
                if (gOST3410DomainParameters.getA().modPow(asymmetricGOST3410PrivateKey.getX(), gOST3410DomainParameters.getP()).equals(asymmetricGOST3410PublicKey.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(p2 instanceof AsymmetricECGOST3410PublicKey) || !(s2 instanceof AsymmetricECGOST3410PrivateKey)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)s2;
            AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)p2;
            GOST3410Parameters<ECDomainParameters> gOST3410Parameters = asymmetricECGOST3410PrivateKey.getParameters();
            ECDomainParameters eCDomainParameters = gOST3410Parameters.getDomainParameters();
            if (eCDomainParameters.getG().multiply(asymmetricECGOST3410PrivateKey.getS()).normalize().equals(asymmetricECGOST3410PublicKey.getW())) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (p2 instanceof AsymmetricDSTU4145Key && s2 instanceof AsymmetricDSTU4145Key) {
            AsymmetricDSTU4145PrivateKey asymmetricDSTU4145PrivateKey = (AsymmetricDSTU4145PrivateKey)s2;
            AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey = (AsymmetricDSTU4145PublicKey)p2;
            if (!asymmetricDSTU4145PrivateKey.getParameters().equals(asymmetricDSTU4145PublicKey.getParameters())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            if (asymmetricDSTU4145PrivateKey.getParameters().getDomainParameters().getG().multiply(asymmetricDSTU4145PrivateKey.getS()).negate().normalize().equals(asymmetricDSTU4145PublicKey.getW())) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (p2 instanceof AsymmetricEdDSAKey && s2 instanceof AsymmetricEdDSAKey) {
            AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey = (AsymmetricEdDSAPrivateKey)s2;
            AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey = (AsymmetricEdDSAPublicKey)p2;
            if (!asymmetricEdDSAPrivateKey.getAlgorithm().equals(asymmetricEdDSAPublicKey.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (Arrays.areEqual(asymmetricEdDSAPrivateKey.getPublicData(), asymmetricEdDSAPublicKey.getPublicData())) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (!(p2 instanceof AsymmetricXDHKey) || !(s2 instanceof AsymmetricXDHKey)) throw new IllegalArgumentException("Key pair inconsistent");
        AsymmetricXDHPrivateKey asymmetricXDHPrivateKey = (AsymmetricXDHPrivateKey)s2;
        AsymmetricXDHPublicKey asymmetricXDHPublicKey = (AsymmetricXDHPublicKey)p2;
        if (!asymmetricXDHPrivateKey.getAlgorithm().equals(asymmetricXDHPublicKey.getAlgorithm())) {
            throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
        }
        if (Arrays.areEqual(asymmetricXDHPrivateKey.getPublicData(), asymmetricXDHPublicKey.getPublicData())) return;
        throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
    }

    public P getPublicKey() {
        return this.publicKey;
    }

    public S getPrivateKey() {
        return this.privateKey;
    }
}

