/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.utils.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410Key;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.utils.ms.core.bc.math.ec.ECPoint;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricECGOST3410PublicKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPublicKey {
    private ECPoint w;

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> gOST3410Parameters, ECPoint eCPoint) {
        super(algorithm, gOST3410Parameters);
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), eCPoint);
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_2001, subjectPublicKeyInfo.getAlgorithm());
        this.w = KeyUtils.validated(((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve(), this.parsePublicKey(subjectPublicKeyInfo));
    }

    private ECPoint parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        int n2;
        ASN1OctetString aSN1OctetString;
        try {
            aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = aSN1OctetString.getOctets();
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        for (n2 = 0; n2 != byArray2.length; ++n2) {
            byArray2[n2] = byArray[31 - n2];
        }
        for (n2 = 0; n2 != byArray3.length; ++n2) {
            byArray3[n2] = byArray[63 - n2];
        }
        return ((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve().validatePoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public ECPoint getW() {
        return this.w;
    }

    @Override
    public byte[] getEncoded() {
        BigInteger bigInteger = this.w.getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = this.w.getAffineYCoord().toBigInteger();
        byte[] byArray = new byte[64];
        this.extractBytes(byArray, 0, bigInteger);
        this.extractBytes(byArray, 32, bigInteger2);
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(byArray));
    }

    private void extractBytes(byte[] byArray, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != 32; ++i2) {
            byArray[n2 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECGOST3410PublicKey)) {
            return false;
        }
        AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)object;
        return this.w.equals(asymmetricECGOST3410PublicKey.w) && this.getParameters().equals(asymmetricECGOST3410PublicKey.getParameters());
    }

    @Override
    public int hashCode() {
        int n2 = this.w.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }
}

