/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsOperationError;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Permissions;
import java.util.Arrays;

public final class SymmetricSecretKey
implements SymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;

    public SymmetricSecretKey(Algorithm algorithm, byte[] byArray) {
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public SymmetricSecretKey(Parameters parameters, byte[] byArray) {
        this.algorithm = parameters.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    private void zeroize() {
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            this.bytes[i2] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        return (byte[])this.bytes.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey symmetricSecretKey = (SymmetricSecretKey)object;
        if (!this.getAlgorithm().equals(symmetricSecretKey.getAlgorithm())) {
            return false;
        }
        return Arrays.equals(this.bytes, symmetricSecretKey.bytes);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int n2 = this.getAlgorithm().hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.bytes);
        return n2;
    }

    protected void finalize() throws Throwable {
        this.zeroize();
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }
}

