/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.extensions;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.extensions.d;
import com.aspose.html.utils.ms.lang.Operators;

public class NetscapeCertTypeExtension
extends X509Extension {
    private int a;

    public NetscapeCertTypeExtension() {
        this.extnOid = "2.16.840.1.113730.1.1";
    }

    public NetscapeCertTypeExtension(ASN1 aSN1) {
        super(aSN1);
    }

    public NetscapeCertTypeExtension(X509Extension x509Extension) {
        super(x509Extension);
    }

    @Override
    public void decode() {
        ASN1 aSN1 = new ASN1(this.extnValue.getValue());
        if (Operators.castToInt32(aSN1.getTag(), 6) != 3) {
            throw new ArgumentException("Invalid NetscapeCertType extension");
        }
        int n2 = 1;
        while (n2 < aSN1.getValue().length) {
            this.a = (this.a << 8) + Operators.castToInt32(aSN1.getValue()[n2++], 6);
        }
    }

    @Override
    public String getName() {
        return "NetscapeCertType";
    }

    public boolean support(int n2) {
        int n3 = Convert.toInt32(Operators.boxing(n2), (IFormatProvider)CultureInfo.getInvariantCulture());
        return (n3 & this.a) == n3;
    }

    @Override
    public String toString() {
        String string = " , ";
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (this.support(128)) {
            msStringBuilder2.append("SSL Client Authentication");
        }
        if (this.support(64)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("SSL Server Authentication");
        }
        if (this.support(32)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("SMIME");
        }
        if (this.support(16)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("Object Signing");
        }
        if (this.support(4)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("SSL CA");
        }
        if (this.support(2)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("SMIME CA");
        }
        if (this.support(1)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(" , ");
            }
            msStringBuilder2.append("Object Signing CA");
        }
        msStringBuilder2.append("(");
        msStringBuilder2.append(Int32Extensions.toString(this.a, "X2", CultureInfo.getInvariantCulture()));
        msStringBuilder2.append(")");
        msStringBuilder2.append(Environment.get_NewLine());
        return msStringBuilder2.toString();
    }

    public static final class CertTypes
    extends Enum {
        public static final int SslClient = 128;
        public static final int SslServer = 64;
        public static final int Smime = 32;
        public static final int ObjectSigning = 16;
        public static final int SslCA = 4;
        public static final int SmimeCA = 2;
        public static final int ObjectSigningCA = 1;

        private CertTypes() {
        }

        static {
            Enum.register(new d((Class)CertTypes.class, Integer.class));
        }
    }
}

