/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.gif;

import com.aspose.html.utils.collections.generic.List;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;

public class PaletteBuilder {
    protected static final int MAXLEVEL = 8;
    protected RenderedImage src;
    protected ColorModel srcColorModel;
    protected Raster srcRaster;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;

    public static RenderedImage createIndexedImage(RenderedImage renderedImage) {
        int n2 = renderedImage.getWidth() * renderedImage.getHeight();
        if (n2 < 256) {
            int n3 = -1;
            List<Color> list = new List<Color>();
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < renderedImage.getHeight(); ++i2) {
                for (int i3 = 0; i3 < renderedImage.getWidth(); ++i3) {
                    int n4 = ((BufferedImage)renderedImage).getRGB(i3, i2);
                    Color color = new Color(n4, true);
                    int n5 = i3 + i2 * renderedImage.getWidth();
                    if (!list.contains(color)) {
                        if (color.getAlpha() == 0) {
                            n3 = list.size();
                        }
                        nArray[n5] = list.size();
                        list.addItem(color);
                        continue;
                    }
                    nArray[n5] = list.indexOf(color);
                }
            }
            n2 = list.size();
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                byArray[i4] = (byte)((Color)list.get_Item(i4)).getRed();
                byArray2[i4] = (byte)((Color)list.get_Item(i4)).getGreen();
                byArray3[i4] = (byte)((Color)list.get_Item(i4)).getBlue();
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, n2, byArray, byArray2, byArray3, n3);
            BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 13, indexColorModel);
            for (int i5 = 0; i5 < renderedImage.getHeight(); ++i5) {
                for (int i6 = 0; i6 < renderedImage.getWidth(); ++i6) {
                    int n6 = i6 + i5 * renderedImage.getWidth();
                    bufferedImage.setRGB(i6, i5, ((BufferedImage)renderedImage).getRGB(i6, i5));
                }
            }
            return bufferedImage;
        }
        PaletteBuilder paletteBuilder = new PaletteBuilder(renderedImage);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexedImage();
    }

    public static IndexColorModel createIndexColorModel(RenderedImage renderedImage) {
        PaletteBuilder paletteBuilder = new PaletteBuilder(renderedImage);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexColorModel();
    }

    public static boolean canCreatePalette(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(renderedImage);
        return PaletteBuilder.canCreatePalette(imageTypeSpecifier);
    }

    protected RenderedImage getIndexedImage() {
        IndexColorModel indexColorModel = this.getIndexColorModel();
        BufferedImage bufferedImage = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                Color color = this.a(i3, i2);
                writableRaster.setSample(i3, i2, 0, this.findColorIndex(this.root, color));
            }
        }
        return bufferedImage;
    }

    protected PaletteBuilder(RenderedImage renderedImage) {
        this(renderedImage, Math.min(256, renderedImage.getHeight() * renderedImage.getWidth()));
    }

    protected PaletteBuilder(RenderedImage renderedImage, int n2) {
        this.src = renderedImage;
        this.srcColorModel = renderedImage.getColorModel();
        this.srcRaster = renderedImage.getData();
        this.transparency = this.srcColorModel.getTransparency();
        if (this.transparency != 1) {
            this.requiredSize = n2 - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = n2;
        }
    }

    private Color a(int n2, int n3) {
        int n4 = this.srcColorModel.getRGB(this.srcRaster.getDataElements(n2, n3, null));
        return new Color(n4, this.transparency != 1);
    }

    protected int findColorIndex(ColorNode colorNode, Color color) {
        if (this.transparency != 1 && color.getAlpha() != 255) {
            return 0;
        }
        if (colorNode.isLeaf) {
            return colorNode.paletteIndex;
        }
        int n2 = this.getBranchIndex(color, colorNode.level);
        return this.findColorIndex(colorNode.children[n2], color);
    }

    protected void buildPalette() {
        int n2;
        this.reduceList = new ColorNode[9];
        for (n2 = 0; n2 < this.reduceList.length; ++n2) {
            this.reduceList[n2] = null;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = 8;
        n2 = 0;
        int n3 = this.src.getWidth();
        int n4 = this.src.getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color = this.a(n3 - i3 - 1, n4 - i2 - 1);
                if (this.transparency != 1 && color.getAlpha() != 255) {
                    if (n2 == 0) {
                        this.root = this.insertNode(this.root, color, 0);
                        n2 = 1;
                    }
                    this.transColor = this.insertNode(this.transColor, color, 0);
                } else {
                    this.root = this.insertNode(this.root, color, 0);
                }
                if (this.currSize <= this.requiredSize) continue;
                this.reduceTree();
            }
        }
    }

    protected ColorNode insertNode(ColorNode colorNode, Color color, int n2) {
        if (colorNode == null) {
            colorNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            colorNode.level = n2;
            boolean bl2 = colorNode.isLeaf = n2 > 8;
            if (colorNode.isLeaf) {
                ++this.currSize;
            }
        }
        ++colorNode.colorCount;
        colorNode.red += (long)color.getRed();
        colorNode.green += (long)color.getGreen();
        colorNode.blue += (long)color.getBlue();
        if (!colorNode.isLeaf) {
            int n3 = this.getBranchIndex(color, n2);
            if (colorNode.children[n3] == null) {
                ++colorNode.childCount;
                if (colorNode.childCount == 2) {
                    colorNode.nextReducible = this.reduceList[n2];
                    this.reduceList[n2] = colorNode;
                }
            }
            colorNode.children[n3] = this.insertNode(colorNode.children[n3], color, n2 + 1);
        }
        return colorNode;
    }

    protected IndexColorModel getIndexColorModel() {
        int n2 = this.currSize;
        if (this.transparency == 2) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        this.palette = new ColorNode[n2];
        if (this.transparency == 2) {
            ++n3;
        }
        int n4 = this.findPaletteEntry(this.root, n3, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = null;
        indexColorModel = this.transparency == 2 ? new IndexColorModel(8, n2, byArray, byArray2, byArray3, 0) : new IndexColorModel(8, this.currSize, byArray, byArray2, byArray3);
        return indexColorModel;
    }

    protected int findPaletteEntry(ColorNode colorNode, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (colorNode.isLeaf) {
            byArray[n2] = (byte)(colorNode.red / (long)colorNode.colorCount);
            byArray2[n2] = (byte)(colorNode.green / (long)colorNode.colorCount);
            byArray3[n2] = (byte)(colorNode.blue / (long)colorNode.colorCount);
            colorNode.paletteIndex = n2;
            this.palette[n2] = colorNode;
            ++n2;
        } else {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (colorNode.children[i2] == null) continue;
                n2 = this.findPaletteEntry(colorNode.children[i2], n2, byArray, byArray2, byArray3);
            }
        }
        return n2;
    }

    protected int getBranchIndex(Color color, int n2) {
        if (n2 > 8 || n2 < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + n2);
        }
        int n3 = 8 - n2;
        int n4 = 1 & (0xFF & color.getRed()) >> n3;
        int n5 = 1 & (0xFF & color.getGreen()) >> n3;
        int n6 = 1 & (0xFF & color.getBlue()) >> n3;
        int n7 = n4 << 2 | n5 << 1 | n6;
        return n7;
    }

    protected void reduceTree() {
        int n2;
        for (n2 = this.reduceList.length - 1; this.reduceList[n2] == null && n2 >= 0; --n2) {
        }
        ColorNode colorNode = this.reduceList[n2];
        if (colorNode == null) {
            return;
        }
        ColorNode colorNode2 = colorNode;
        int n3 = colorNode2.colorCount;
        int n4 = 1;
        while (colorNode2.nextReducible != null) {
            if (n3 > colorNode2.nextReducible.colorCount) {
                colorNode = colorNode2;
                n3 = colorNode2.colorCount;
            }
            colorNode2 = colorNode2.nextReducible;
            ++n4;
        }
        if (colorNode == this.reduceList[n2]) {
            this.reduceList[n2] = colorNode.nextReducible;
        } else {
            colorNode2 = colorNode.nextReducible;
            colorNode.nextReducible = colorNode2.nextReducible;
            colorNode = colorNode2;
        }
        if (colorNode.isLeaf) {
            return;
        }
        int n5 = colorNode.getLeafChildCount();
        colorNode.isLeaf = true;
        this.currSize -= n5 - 1;
        int n6 = colorNode.level;
        for (int i2 = 0; i2 < 8; ++i2) {
            colorNode.children[i2] = this.freeTree(colorNode.children[i2]);
        }
        colorNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode colorNode) {
        if (colorNode == null) {
            return null;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            colorNode.children[i2] = this.freeTree(colorNode.children[i2]);
        }
        --this.numNodes;
        return null;
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        ColorNode nextReducible;

        public ColorNode() {
            for (int i2 = 0; i2 < 8; ++i2) {
                this.children[i2] = null;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int n2 = 0;
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                if (this.children[i2] == null) continue;
                if (this.children[i2].isLeaf) {
                    ++n2;
                    continue;
                }
                n2 += this.children[i2].getLeafChildCount();
            }
            return n2;
        }

        public int getRGB() {
            int n2 = (int)this.red / this.colorCount;
            int n3 = (int)this.green / this.colorCount;
            int n4 = (int)this.blue / this.colorCount;
            int n5 = 0xFF000000 | (0xFF & n2) << 16 | (0xFF & n3) << 8 | 0xFF & n4;
            return n5;
        }
    }
}

