/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.CMYKColor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.icc.IccCmm;
import com.aspose.html.utils.ms.lang.Operators;

public class CMYKHelper {
    public static CMYKColor[] toCMYK(int[] nArray) {
        CMYKColor[] cMYKColorArray = (CMYKColor[])Array.unboxing(Array.createInstance(Operators.typeOf(CMYKColor.class), nArray.length));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = msMath.min(msMath.min(255 - (ColorHelper.fromArgb(nArray[i2]).getBlue() & 0xFF), 255 - (ColorHelper.fromArgb(nArray[i2]).getGreen() & 0xFF)), 255 - (ColorHelper.fromArgb(nArray[i2]).getRed() & 0xFF));
            if (n2 < 255) {
                int n3 = 255 * (255 - (ColorHelper.fromArgb(nArray[i2]).getRed() & 0xFF) - n2) / (255 - n2);
                int n4 = 255 * (255 - (ColorHelper.fromArgb(nArray[i2]).getGreen() & 0xFF) - n2) / (255 - n2);
                int n5 = 255 * (255 - (ColorHelper.fromArgb(nArray[i2]).getBlue() & 0xFF) - n2) / (255 - n2);
                CMYKColor.fromParams(n3, n4, n5, n2).CloneTo(cMYKColorArray[i2]);
                continue;
            }
            CMYKColor.fromParams(0, 0, 0, n2).CloneTo(cMYKColorArray[i2]);
        }
        return cMYKColorArray;
    }

    public static CMYKColor toCMYK(int n2) {
        int n3 = msMath.min(msMath.min(255 - (ColorHelper.fromArgb(n2).getBlue() & 0xFF), 255 - (ColorHelper.fromArgb(n2).getGreen() & 0xFF)), 255 - (ColorHelper.fromArgb(n2).getRed() & 0xFF));
        if (n3 < 255) {
            int n4 = 255 * (255 - (ColorHelper.fromArgb(n2).getRed() & 0xFF) - n3) / (255 - n3);
            int n5 = 255 * (255 - (ColorHelper.fromArgb(n2).getGreen() & 0xFF) - n3) / (255 - n3);
            int n6 = 255 * (255 - (ColorHelper.fromArgb(n2).getBlue() & 0xFF) - n3) / (255 - n3);
            return CMYKColor.fromParams(n4, n5, n6, n3);
        }
        return CMYKColor.fromParams(0, 0, 0, n3);
    }

    public static int[] toColor(CMYKColor[] cMYKColorArray) {
        int[] nArray = new int[cMYKColorArray.length];
        for (int i2 = 0; i2 < cMYKColorArray.length; ++i2) {
            nArray[i2] = ColorHelper.toArgb(ColorHelper.fromArgb((255 - (cMYKColorArray[i2].getC() & 0xFF)) * (255 - (cMYKColorArray[i2].getK() & 0xFF)) / 255, (255 - (cMYKColorArray[i2].getM() & 0xFF)) * (255 - (cMYKColorArray[i2].getK() & 0xFF)) / 255, (255 - (cMYKColorArray[i2].getY() & 0xFF)) * (255 - (cMYKColorArray[i2].getK() & 0xFF)) / 255));
        }
        return nArray;
    }

    public static int toColor(CMYKColor cMYKColor) {
        int n2 = msMath.min(255, (cMYKColor.getC() & 0xFF) + (cMYKColor.getK() & 0xFF));
        int n3 = msMath.min(255, (cMYKColor.getM() & 0xFF) + (cMYKColor.getK() & 0xFF));
        int n4 = msMath.min(255, (cMYKColor.getY() & 0xFF) + (cMYKColor.getK() & 0xFF));
        return ColorHelper.toArgb(ColorHelper.fromArgb(255 - (cMYKColor.getC() & 0xFF), 255 - (cMYKColor.getM() & 0xFF), 255 - (cMYKColor.getY() & 0xFF)));
    }

    public static int toColorIcc(CMYKColor cMYKColor, Stream stream, Stream stream2) {
        IccCmm iccCmm = new IccCmm(stream, stream2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        long l2 = cMYKColor.toValue();
        dArray2[0] = (double)(l2 >> 24 & 0xFFL) / 255.0;
        dArray2[1] = (double)(l2 >> 16 & 0xFFL) / 255.0;
        dArray2[2] = (double)(l2 >> 8 & 0xFFL) / 255.0;
        dArray2[3] = (double)(l2 & 0xFFL) / 255.0;
        iccCmm.apply(dArray2, dArray);
        return ColorHelper.toArgb((byte)(dArray[0] * 255.0), (byte)(dArray[1] * 255.0), (byte)(dArray[2] * 255.0));
    }

    public static int[] toColorIcc(CMYKColor[] cMYKColorArray) {
        return CMYKHelper.toColorIcc(cMYKColorArray, IccProfileHelper.getDefaultCmykProfile().getStream(), IccProfileHelper.getDefaultRGBProfile().getStream());
    }

    public static int toColorIcc(CMYKColor cMYKColor) {
        return CMYKHelper.toColorIcc(cMYKColor.Clone(), IccProfileHelper.getDefaultCmykProfile().getStream(), IccProfileHelper.getDefaultRGBProfile().getStream());
    }

    public static int[] toColorIcc(CMYKColor[] cMYKColorArray, Stream stream, Stream stream2) {
        IccCmm iccCmm = new IccCmm(stream, stream2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int[] nArray = ArrayHelper.getColors(cMYKColorArray.length);
        for (int i2 = 0; i2 < cMYKColorArray.length; ++i2) {
            long l2 = cMYKColorArray[i2].toValue();
            dArray2[0] = (double)(l2 >> 24 & 0xFFL) / 255.0;
            dArray2[1] = (double)(l2 >> 16 & 0xFFL) / 255.0;
            dArray2[2] = (double)(l2 >> 8 & 0xFFL) / 255.0;
            dArray2[3] = (double)(l2 & 0xFFL) / 255.0;
            iccCmm.apply(dArray2, dArray);
            nArray[i2] = ColorHelper.toArgb((byte)(dArray[0] * 255.0), (byte)(dArray[1] * 255.0), (byte)(dArray[2] * 255.0));
        }
        return nArray;
    }

    public static CMYKColor[] toCMYKIcc(int[] nArray, Stream stream, Stream stream2) {
        IccCmm iccCmm = new IccCmm(stream, stream2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        CMYKColor[] cMYKColorArray = (CMYKColor[])Array.unboxing(Array.createInstance(Operators.typeOf(CMYKColor.class), nArray.length));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            dArray[0] = (double)(n2 >> 16 & 0xFF) / 255.0;
            dArray[1] = (double)(n2 >> 8 & 0xFF) / 255.0;
            dArray[2] = (double)(n2 & 0xFF) / 255.0;
            iccCmm.apply(dArray, dArray2);
            cMYKColorArray[i2] = CMYKColor.fromParams((byte)(255.0 * dArray2[0]), (byte)(255.0 * dArray2[1]), (byte)(255.0 * dArray2[2]), (byte)(255.0 * dArray2[3]));
        }
        return cMYKColorArray;
    }

    public static CMYKColor[] toCMYKIcc(int[] nArray) {
        return CMYKHelper.toCMYKIcc(nArray, IccProfileHelper.getDefaultRGBProfile().getStream(), IccProfileHelper.getDefaultCmykProfile().getStream());
    }

    public static CMYKColor toCMYKIcc(int n2) {
        return CMYKHelper.toCMYKIcc(n2, IccProfileHelper.getDefaultRGBProfile().getStream(), IccProfileHelper.getDefaultCmykProfile().getStream());
    }

    public static CMYKColor toCMYKIcc(int n2, Stream stream, Stream stream2) {
        IccCmm iccCmm = new IccCmm(stream, stream2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[4];
        int n3 = n2;
        dArray[0] = (double)(n3 >> 16 & 0xFF) / 255.0;
        dArray[1] = (double)(n3 >> 8 & 0xFF) / 255.0;
        dArray[2] = (double)(n3 & 0xFF) / 255.0;
        iccCmm.apply(dArray, dArray2);
        return CMYKColor.fromParams((byte)(255.0 * dArray2[0]), (byte)(255.0 * dArray2[1]), (byte)(255.0 * dArray2[2]), (byte)(255.0 * dArray2[3]));
    }
}

