/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.ArithmeticException;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.MidpointRounding;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.SingleExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.UInt64Extensions;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class msMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static ThreadLocal<DecimalFormat> a = new ThreadLocal();

    private static DecimalFormat a() {
        if (a.get() == null) {
            a.set(new DecimalFormat("###.", new DecimalFormatSymbols(Locale.ENGLISH)));
        }
        return a.get();
    }

    public static void clearCurrentThreadLocals() {
        a.remove();
    }

    public static Decimal abs(Decimal decimal) {
        return Decimal.op_LessThan(decimal, Decimal.newDecimalFromInt(0)) ? Decimal.op_UnaryNegation(decimal) : decimal;
    }

    public static double abs(double d2) {
        return d2 < 0.0 ? -d2 : d2;
    }

    public static float abs(float f2) {
        return f2 < 0.0f ? -f2 : f2;
    }

    public static int abs(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return n2 < 0 ? -n2 : n2;
    }

    public static long abs(long l2) {
        if (l2 == Long.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return l2 < 0L ? -l2 : l2;
    }

    public static byte abs(byte by2) {
        if (by2 == -128) {
            throw new OverflowException("Value is too small.");
        }
        return by2 < 0 ? -by2 : by2;
    }

    public static short abs(short s2) {
        if (s2 == Short.MIN_VALUE) {
            throw new OverflowException("Value is too small.");
        }
        return s2 < 0 ? -s2 : s2;
    }

    public static Decimal ceiling(Decimal decimal) {
        Decimal decimal2 = msMath.floor(decimal);
        if (Decimal.op_Inequality(decimal2, decimal)) {
            decimal2 = Decimal.op_Increment(decimal2);
        }
        return decimal2;
    }

    public static double ceiling(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        double d3 = msMath.floor(d2);
        if (d3 != d2) {
            d3 += 1.0;
        }
        return d3;
    }

    public static double floor(double d2) {
        return Math.floor(d2);
    }

    public static long bigMul(int n2, int n3) {
        return (long)n2 * (long)n3;
    }

    public static int divRem(int n2, int n3, int[] nArray) {
        nArray[0] = n2 % n3;
        return n2 / n3;
    }

    public static long divRem(long l2, long l3, long[] lArray) {
        lArray[0] = l2 % l3;
        return l2 / l3;
    }

    public static double iEEERemainder(double d2, double d3) {
        if (d3 == 0.0) {
            return Double.NaN;
        }
        double d4 = d2 - d3 * (double)Math.round(d2 / d3);
        if (d4 != 0.0) {
            return d4;
        }
        return d2 > 0.0 ? 0.0 : BitConverter.int64BitsToDouble(Long.MIN_VALUE);
    }

    public static double log(double d2, double d3) {
        if (d3 == 1.0) {
            return Double.NaN;
        }
        double d4 = msMath.log(d2) / msMath.log(d3);
        return d4 == 0.0 ? 0.0 : d4;
    }

    public static byte max(byte by2, byte by3) {
        return (by2 & 0xFF) > (by3 & 0xFF) ? by2 : by3;
    }

    public static Decimal max(Decimal decimal, Decimal decimal2) {
        return Decimal.op_GreaterThan(decimal, decimal2) ? decimal : decimal2;
    }

    public static double max(double d2, double d3) {
        if (DoubleExtensions.isNaN(d2) || DoubleExtensions.isNaN(d3)) {
            return Double.NaN;
        }
        return d2 > d3 ? d2 : d3;
    }

    public static float max(float f2, float f3) {
        if (SingleExtensions.isNaN(f2) || SingleExtensions.isNaN(f3)) {
            return Float.NaN;
        }
        return f2 > f3 ? f2 : f3;
    }

    public static int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    public static long max(long l2, long l3) {
        return l2 > l3 ? l2 : l3;
    }

    public static byte maxSByte(byte by2, byte by3) {
        return by2 > by3 ? by2 : by3;
    }

    public static short max(short s2, short s3) {
        return s2 > s3 ? s2 : s3;
    }

    public static long maxUInt(long l2, long l3) {
        return (l2 & 0xFFFFFFFFL) > (l3 & 0xFFFFFFFFL) ? l2 & 0xFFFFFFFFL : l3 & 0xFFFFFFFFL;
    }

    public static long maxULong(long l2, long l3) {
        return UInt64Extensions.compareTo(l2, l3) > 0 ? l2 : l3;
    }

    public static int maxUShort(int n2, int n3) {
        return (n2 & 0xFFFF) > (n3 & 0xFFFF) ? n2 & 0xFFFF : n3 & 0xFFFF;
    }

    public static byte min(byte by2, byte by3) {
        return (by2 & 0xFF) < (by3 & 0xFF) ? by2 : by3;
    }

    public static Decimal min(Decimal decimal, Decimal decimal2) {
        return Decimal.op_LessThan(decimal, decimal2) ? decimal : decimal2;
    }

    public static double min(double d2, double d3) {
        if (DoubleExtensions.isNaN(d2) || DoubleExtensions.isNaN(d3)) {
            return Double.NaN;
        }
        return d2 < d3 ? d2 : d3;
    }

    public static float min(float f2, float f3) {
        if (SingleExtensions.isNaN(f2) || SingleExtensions.isNaN(f3)) {
            return Float.NaN;
        }
        return f2 < f3 ? f2 : f3;
    }

    public static int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    public static long min(long l2, long l3) {
        return l2 < l3 ? l2 : l3;
    }

    public static byte minSByte(byte by2, byte by3) {
        return by2 < by3 ? by2 : by3;
    }

    public static short min(short s2, short s3) {
        return s2 < s3 ? s2 : s3;
    }

    public static long minUInt(long l2, long l3) {
        return (l2 & 0xFFFFFFFFL) < (l3 & 0xFFFFFFFFL) ? l2 & 0xFFFFFFFFL : l3 & 0xFFFFFFFFL;
    }

    public static long minULong(long l2, long l3) {
        return UInt64Extensions.compareTo(l2, l3) < 0 ? l2 : l3;
    }

    public static int minUShort(int n2, int n3) {
        return (n2 & 0xFFFF) < (n3 & 0xFFFF) ? n2 & 0xFFFF : n3 & 0xFFFF;
    }

    public static Decimal round(Decimal decimal) {
        Decimal decimal2 = Decimal.floor(decimal);
        Decimal decimal3 = Decimal.op_Subtraction(decimal, decimal2);
        if (Decimal.op_Equality(decimal3, new Decimal("0.5")) && Decimal.op_Inequality(Decimal.op_Multiply(new Decimal("2.0"), Decimal.op_Subtraction(Decimal.op_Division(decimal2, new Decimal("2.0")), Decimal.floor(Decimal.op_Division(decimal2, new Decimal("2.0"))))), new Decimal("0.0")) || Decimal.op_GreaterThan(decimal3, new Decimal("0.5"))) {
            decimal2 = Decimal.op_Increment(decimal2);
        }
        return decimal2;
    }

    public static Decimal round(Decimal decimal, int n2) {
        return Decimal.round(decimal, n2);
    }

    public static Decimal round(Decimal decimal, short s2) {
        if (s2 != 0 && s2 != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, s2), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (s2 == 0) {
            return msMath.round(decimal);
        }
        return msMath.a(decimal);
    }

    static Decimal a(Decimal decimal) {
        Decimal decimal2 = Decimal.floor(decimal);
        Decimal decimal3 = Decimal.op_Subtraction(decimal, decimal2);
        if (Decimal.op_GreaterThanOrEqual(decimal2, Decimal.newDecimalFromInt(0)) && Decimal.op_GreaterThanOrEqual(decimal3, new Decimal("0.5"))) {
            decimal2 = Decimal.op_Increment(decimal2);
        } else if (Decimal.op_LessThan(decimal2, Decimal.newDecimalFromInt(0)) && Decimal.op_GreaterThan(decimal3, new Decimal("0.5"))) {
            decimal2 = Decimal.op_Increment(decimal2);
        }
        return decimal2;
    }

    public static Decimal round(Decimal decimal, int n2, short s2) {
        return Decimal.round(decimal, n2, s2);
    }

    public static double round(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (d2 == 0.0) {
            return d2;
        }
        double d3 = msMath.floor(d2);
        double d4 = msMath.ceiling(d2);
        if (msMath.abs(d4 - d2) == msMath.abs(d3 - d2)) {
            return msMath.abs(d3 % 2.0) == 1.0 ? d4 : d3;
        }
        return msMath.abs(d4 - d2) > msMath.abs(d3 - d2) ? d3 : d4;
    }

    public static double round(double d2, int n2) {
        double d3;
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (n2 < 0 || n2 > 15) {
            throw new ArgumentOutOfRangeException("Value is too small or too big.");
        }
        if (n2 == 0) {
            return msMath.round(d2);
        }
        if (n2 == 2) {
            try {
                d3 = Double.parseDouble(msMath.a().format(d2 * 100.0)) / 100.0;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                d3 = msMath.a(d2, n2, (short)0);
            }
            catch (NumberFormatException numberFormatException) {
                DecimalFormat decimalFormat = new DecimalFormat("###.");
                d3 = Double.parseDouble(decimalFormat.format(d2 * 100.0)) / 100.0;
            }
        } else {
            d3 = msMath.a(d2, n2, (short)0);
        }
        return d3;
    }

    public static double round(double d2, short s2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (s2 != 0 && s2 != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, s2), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (s2 == 0) {
            return msMath.round(d2);
        }
        if (d2 > 0.0) {
            return msMath.floor(d2 + 0.5);
        }
        return msMath.ceiling(d2 - 0.5);
    }

    public static double round(double d2, int n2, short s2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (s2 != 0 && s2 != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, s2), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (n2 == 0) {
            return msMath.round(d2, s2);
        }
        return msMath.a(d2, n2, s2);
    }

    private static double a(double d2, int n2, short s2) {
        Decimal decimal = Decimal.newDecimalFromDouble(d2);
        decimal = Decimal.round(decimal, n2, s2);
        return Decimal.to_DoubleFromDecimal(decimal);
    }

    public static double truncate(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return d2;
        }
        if (d2 > 0.0) {
            return msMath.floor(d2);
        }
        if (d2 < 0.0) {
            return msMath.ceiling(d2);
        }
        return d2;
    }

    public static Decimal truncate(Decimal decimal) {
        return Decimal.truncate(decimal);
    }

    public static Decimal floor(Decimal decimal) {
        return Decimal.floor(decimal);
    }

    public static int sign(Decimal decimal) {
        if (Decimal.op_GreaterThan(decimal, Decimal.newDecimalFromInt(0))) {
            return 1;
        }
        return Decimal.op_Equality(decimal, Decimal.newDecimalFromInt(0)) ? 0 : -1;
    }

    public static int sign(double d2) {
        if (DoubleExtensions.isNaN(d2)) {
            throw new ArithmeticException("NAN");
        }
        if (d2 > 0.0) {
            return 1;
        }
        return d2 == 0.0 ? 0 : -1;
    }

    public static int sign(float f2) {
        if (SingleExtensions.isNaN(f2)) {
            throw new ArithmeticException("NAN");
        }
        if (f2 > 0.0f) {
            return 1;
        }
        return f2 == 0.0f ? 0 : -1;
    }

    public static int sign(int n2) {
        if (n2 > 0) {
            return 1;
        }
        return n2 == 0 ? 0 : -1;
    }

    public static int sign(long l2) {
        if (l2 > 0L) {
            return 1;
        }
        return l2 == 0L ? 0 : -1;
    }

    public static int sign(byte by2) {
        if (by2 > 0) {
            return 1;
        }
        return by2 == 0 ? 0 : -1;
    }

    public static int sign(short s2) {
        if (s2 > 0) {
            return 1;
        }
        return s2 == 0 ? 0 : -1;
    }

    public static double sin(double d2) {
        return Math.sin(d2);
    }

    public static double cos(double d2) {
        return Math.cos(d2);
    }

    public static double tan(double d2) {
        return Math.tan(d2);
    }

    public static double sinh(double d2) {
        return Math.sinh(d2);
    }

    public static double cosh(double d2) {
        return Math.cosh(d2);
    }

    public static double tanh(double d2) {
        return Math.tanh(d2);
    }

    public static double acos(double d2) {
        return Math.acos(d2);
    }

    public static double asin(double d2) {
        return Math.asin(d2);
    }

    public static double atan(double d2) {
        return Math.atan(d2);
    }

    public static double atan2(double d2, double d3) {
        return Math.atan2(d2, d3);
    }

    public static double exp(double d2) {
        return Math.exp(d2);
    }

    public static double log(double d2) {
        return Math.log(d2);
    }

    public static double log10(double d2) {
        return Math.log10(d2);
    }

    public static double pow(double d2, double d3) {
        if (DoubleExtensions.isNaN(d2)) {
            return Double.NaN;
        }
        return Math.pow(d2, d3);
    }

    public static double sqrt(double d2) {
        return Math.sqrt(d2);
    }
}

