/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Xml.BaseIterator;
import com.aspose.html.utils.ms.System.Xml.XPathNavigator;
import com.aspose.html.utils.ms.System.Xml.XPathNodeIterator;
import com.aspose.html.utils.ms.System.Xml.XmlChar;

class XPathFunctions {
    XPathFunctions() {
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            throw new ArgumentNullException();
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Double) {
            double d2 = (Double)object;
            return d2 != 0.0 && !Double.isNaN(d2);
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof XPathNodeIterator) {
            XPathNodeIterator xPathNodeIterator = (XPathNodeIterator)object;
            return xPathNodeIterator.moveNext();
        }
        if (object instanceof XPathNavigator) {
            return XPathFunctions.toBoolean(((XPathNavigator)object).selectChildren(9));
        }
        throw new ArgumentException();
    }

    public static boolean toBoolean(boolean bl2) {
        return bl2;
    }

    public static boolean toBoolean(double d2) {
        return d2 != 0.0 && !Double.isNaN(d2);
    }

    public static boolean toBoolean(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean toBoolean(BaseIterator baseIterator) {
        return baseIterator != null && baseIterator.moveNext();
    }

    public static String toString(Object object) {
        if (object == null) {
            throw new ArgumentNullException();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object instanceof Double) {
            return XPathFunctions.toString((Double)object);
        }
        if (object instanceof XPathNodeIterator) {
            XPathNodeIterator xPathNodeIterator = (XPathNodeIterator)object;
            if (!xPathNodeIterator.moveNext()) {
                return "";
            }
            return xPathNodeIterator.getCurrent().getValue();
        }
        if (object instanceof XPathNavigator) {
            return ((XPathNavigator)object).getValue();
        }
        throw new ArgumentException();
    }

    public static String toString(double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        return DoubleExtensions.toString(d2, "R", NumberFormatInfo.getInvariantInfo());
    }

    public static double toNumber(Object object) {
        if (object == null) {
            throw new ArgumentNullException();
        }
        if (object instanceof BaseIterator || object instanceof XPathNavigator) {
            object = XPathFunctions.toString(object);
        }
        if (object instanceof String) {
            String string = (String)object;
            return XPathFunctions.toNumber(string);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return Convert.toDouble((Boolean)object);
        }
        throw new ArgumentException();
    }

    public static double toNumber(String string) {
        if (string == null) {
            throw new ArgumentNullException();
        }
        String string2 = StringExtensions.trim(string, XmlChar.WhitespaceChars);
        if (string2.length() == 0) {
            return Double.NaN;
        }
        try {
            if (string2.charAt(0) == '.') {
                string2 = StringExtensions.concat(Character.valueOf('.'), string2);
            }
            return DoubleExtensions.parse(string2, 39, NumberFormatInfo.getInvariantInfo());
        }
        catch (OverflowException overflowException) {
            return Double.NaN;
        }
        catch (FormatException formatException) {
            return Double.NaN;
        }
    }
}

