/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.InvalidCastException;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.System.Xml.ObjectMap;
import com.aspose.html.utils.ms.System.Xml.XmlCustomFormatter;
import com.aspose.html.utils.ms.lang.Operators;

class EnumMap
extends ObjectMap {
    EnumMapMember[] _members;
    boolean _isFlags;
    String[] _enumNames = null;
    String[] _xmlNames = null;
    long[] _values = null;

    public EnumMap(EnumMapMember[] enumMapMemberArray, boolean bl2) {
        this._members = enumMapMemberArray;
        this._isFlags = bl2;
        this._enumNames = new String[this._members.length];
        this._xmlNames = new String[this._members.length];
        this._values = new long[this._members.length];
        for (int i2 = 0; i2 < this._members.length; ++i2) {
            EnumMapMember enumMapMember = this._members[i2];
            this._enumNames[i2] = enumMapMember.getEnumName();
            this._xmlNames[i2] = enumMapMember.getXmlName();
            this._values[i2] = enumMapMember.getValue();
        }
    }

    public boolean isFlags() {
        return this._isFlags;
    }

    public EnumMapMember[] getMembers() {
        return this._members;
    }

    public String[] getEnumNames() {
        return this._enumNames;
    }

    public String[] getXmlNames() {
        return this._xmlNames;
    }

    public long[] getValues() {
        return this._values;
    }

    public String getXmlName(String string, Object object) {
        if (object instanceof String) {
            throw new InvalidCastException();
        }
        long l2 = 0L;
        try {
            Type type = Operators.typeOf(object.getClass());
            l2 = type.isEnum() ? ((Enum)object).get_Value() : Convert.toInt64(object);
        }
        catch (FormatException formatException) {
            throw new InvalidCastException();
        }
        catch (NotImplementedException notImplementedException) {
            throw new InvalidOperationException();
        }
        for (int i2 = 0; i2 < this.getValues().length; ++i2) {
            if (this.getValues()[i2] != l2) continue;
            return this.getXmlNames()[i2];
        }
        if (this.isFlags() && l2 == 0L) {
            return StringExtensions.Empty;
        }
        String string2 = StringExtensions.Empty;
        if (this.isFlags()) {
            string2 = XmlCustomFormatter.fromEnum(l2, this.getXmlNames(), this.getValues(), string);
        }
        if (string2.length() == 0) {
            throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", l2, string));
        }
        return string2;
    }

    public String getEnumName(String string, String string2) {
        if (this._isFlags) {
            String[] stringArray;
            if ((string2 = StringExtensions.trim(string2)).length() == 0) {
                return "0";
            }
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (String string3 : stringArray = StringExtensions.split(string2, null)) {
                if (StringExtensions.equals(string3, StringExtensions.Empty)) continue;
                String string4 = null;
                for (int i2 = 0; i2 < this.getXmlNames().length; ++i2) {
                    if (!StringExtensions.equals(this.getXmlNames()[i2], string3)) continue;
                    string4 = this.getEnumNames()[i2];
                    break;
                }
                if (string4 != null) {
                    if (msStringBuilder2.getLength() > 0) {
                        msStringBuilder2.append(',');
                    }
                    msStringBuilder2.append(string4);
                    continue;
                }
                throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", string3, string));
            }
            return msStringBuilder2.toString();
        }
        for (EnumMapMember enumMapMember : this._members) {
            if (!StringExtensions.equals(enumMapMember.getXmlName(), string2)) continue;
            return enumMapMember.getEnumName();
        }
        return null;
    }

    public static class EnumMapMember {
        String _xmlName;
        String _enumName;
        long _value;
        private String a;

        public EnumMapMember(String string, String string2) {
            this(string, string2, 0L);
        }

        public EnumMapMember(String string, String string2, long l2) {
            this._xmlName = string;
            this._enumName = string2;
            this._value = l2;
        }

        public String getXmlName() {
            return this._xmlName;
        }

        public String getEnumName() {
            return this._enumName;
        }

        public long getValue() {
            return this._value;
        }

        public String getDocumentation() {
            return this.a;
        }

        public void setDocumentation(String string) {
            this.a = string;
        }
    }
}

