/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Threading;

import com.aspose.html.utils.TimeSpan;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.Guid;
import com.aspose.html.utils.ms.System.IntPtr;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.MulticastDelegate;
import com.aspose.html.utils.ms.System.Runtime.ConstrainedExecution.CriticalFinalizerObject;
import com.aspose.html.utils.ms.System.Runtime.InteropServices._Thread;
import com.aspose.html.utils.ms.System.SecurityException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Threading.CompressedStack;
import com.aspose.html.utils.ms.System.Threading.ExecutionContext;
import com.aspose.html.utils.ms.System.Threading.ParameterizedThreadStart;
import com.aspose.html.utils.ms.System.Threading.ThreadAbortException;
import com.aspose.html.utils.ms.System.Threading.ThreadInterruptedException;
import com.aspose.html.utils.ms.System.Threading.ThreadStart;
import com.aspose.html.utils.ms.System.Threading.ThreadStateException;
import java.util.Locale;

public final class Thread
extends CriticalFinalizerObject
implements _Thread {
    private java.lang.Thread a;
    private CultureInfo b;
    private CultureInfo c;
    private int d = 2;
    private boolean e = false;
    private String f;
    private int g = 8;
    private Object h = new Object();
    private Object i = null;
    private boolean j = false;
    private static int k = 0;
    private static volatile ThreadLocal<Thread> l = new ThreadLocal();
    private static volatile ThreadLocal<ExecutionContext> m = new ThreadLocal();
    private Object n;
    private MulticastDelegate o;

    private Thread(java.lang.Thread thread) {
        this.a = thread;
        this.f = thread.getName();
    }

    public Thread(final ThreadStart threadStart) {
        if (threadStart == null) {
            throw new ArgumentNullException("Null ThreadStart");
        }
        ThreadStart threadStart2 = new ThreadStart(){

            @Override
            public void invoke() {
                threadStart.invoke();
            }
        };
        this.o = threadStart2;
        this.a = this.a(threadStart2);
    }

    public Thread(final ThreadStart threadStart, int n2) {
        if (threadStart == null) {
            throw new ArgumentNullException("start");
        }
        ThreadStart threadStart2 = new ThreadStart(){

            @Override
            public void invoke() {
                threadStart.invoke();
            }
        };
        this.o = threadStart2;
        this.a = this.a(threadStart2, n2);
    }

    public Thread(final ParameterizedThreadStart parameterizedThreadStart) {
        if (parameterizedThreadStart == null) {
            throw new ArgumentNullException("start");
        }
        ParameterizedThreadStart parameterizedThreadStart2 = new ParameterizedThreadStart(){

            @Override
            public void invoke(Object object) {
                parameterizedThreadStart.invoke(object);
            }
        };
        this.o = parameterizedThreadStart2;
        this.a = this.a(parameterizedThreadStart2);
    }

    public Thread(final ParameterizedThreadStart parameterizedThreadStart, int n2) {
        if (parameterizedThreadStart == null) {
            throw new ArgumentNullException("start");
        }
        ParameterizedThreadStart parameterizedThreadStart2 = new ParameterizedThreadStart(){

            @Override
            public void invoke(Object object) {
                parameterizedThreadStart.invoke(object);
            }
        };
        this.o = parameterizedThreadStart2;
        this.a = this.a(parameterizedThreadStart2, n2);
    }

    private java.lang.Thread a(final ThreadStart threadStart) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                threadStart.invoke();
            }
        }, this.b());
    }

    public static Thread getCurrentThread() {
        Thread thread = l.get();
        if (thread == null) {
            thread = new Thread(java.lang.Thread.currentThread());
            l.set(thread);
        }
        return thread;
    }

    public static void clearCurrentThreadLocals() {
        l.remove();
        m.remove();
    }

    private java.lang.Thread a(final ParameterizedThreadStart parameterizedThreadStart) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                parameterizedThreadStart.invoke(Thread.this.i);
            }
        }, this.b());
    }

    private java.lang.Thread a(final ParameterizedThreadStart parameterizedThreadStart, int n2) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                parameterizedThreadStart.invoke(Thread.this.i);
            }
        }, this.b(), n2);
    }

    private java.lang.Thread a(final ThreadStart threadStart, int n2) {
        return new java.lang.Thread(this.a(), new Runnable(){

            @Override
            public void run() {
                threadStart.invoke();
            }
        }, this.b(), n2);
    }

    private ThreadGroup a() {
        return java.lang.Thread.currentThread().getThreadGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b() {
        Object object = this.h;
        synchronized (object) {
        }
        return StringExtensions.format("{0}_{1}", this.a(), ++k);
    }

    public void abort() {
        try {
            this.g |= 0x80;
            this.a.checkAccess();
            if (this.a.isAlive()) {
                if ((this.g & 0x40) == 64) {
                    throw new ThreadStateException();
                }
                this.a.stop();
                this.g = 256;
                throw new ThreadAbortException();
            }
            this.j = true;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void abort(Object object) {
        this.set_AbortReason(object);
        try {
            this.g |= 0x80;
            this.a.checkAccess();
            if (!this.a.isAlive()) {
                this.j = true;
            }
            if ((this.g & 0x40) == 64) {
                throw new ThreadStateException();
            }
            this.a.stop();
            this.g = 256;
            throw new ThreadAbortException();
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public Object get_AbortReason() {
        return this.n;
    }

    public void set_AbortReason(Object object) {
        this.n = object;
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void interrupt() {
        try {
            this.g = 16;
            this.a.interrupt();
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void join() {
        try {
            this.g |= 0x20;
            this.a.join();
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
    }

    public boolean join(int n2) {
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        try {
            if (n2 == -1) {
                n2 = 0;
            } else if (n2 == 0) {
                n2 = 1;
            }
            this.g |= 0x20;
            this.a.join(n2);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
        return !this.a.isAlive();
    }

    public boolean join(TimeSpan timeSpan) {
        try {
            long l2 = (long)timeSpan.getTotalMilliseconds();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new ArgumentOutOfRangeException("timeout", "timeout out of range");
            }
            this.g |= 0x20;
            this.a.join(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException();
        }
        return !this.a.isAlive();
    }

    public void resume() {
        try {
            if (!this.a.isAlive() || (this.g & 0x40) != 64) {
                throw new ThreadStateException("The thread has not been started, is dead, or is not in the suspended state.");
            }
            this.a.resume();
            if (this.a.isAlive()) {
                this.g ^= 0x40;
            }
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public static void sleep(int n2) {
        if (n2 < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        try {
            Thread.getCurrentThread().g |= 0x20;
            if (n2 == -1) {
                java.lang.Thread.sleep(Long.MAX_VALUE);
            } else {
                java.lang.Thread.sleep(n2);
            }
            Thread.getCurrentThread().g ^= 0x20;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
    }

    public static void sleep(TimeSpan timeSpan) {
        try {
            long l2 = (long)timeSpan.getTotalMilliseconds();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new ArgumentOutOfRangeException("timeout", "timeout out of range");
            }
            Thread.getCurrentThread().g |= 0x20;
            java.lang.Thread.sleep(l2);
            Thread.getCurrentThread().g ^= 0x20;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
    }

    public void start() {
        try {
            if (!this.j) {
                if (this.a.isAlive()) {
                    throw new ThreadStateException();
                }
            } else {
                throw new ThreadStateException("Thread was aborted");
            }
            this.a.checkAccess();
            this.a.start();
            this.g = 0;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    public void start(Object object) {
        if (this.o instanceof ThreadStart) {
            throw new InvalidOperationException("The thread was created with a ThreadStart delegate that does not accept a parameter.");
        }
        this.i = object;
        try {
            if (!this.j) {
                if (this.a.isAlive()) {
                    throw new ThreadStateException();
                }
                this.a.checkAccess();
                this.a.start();
                this.g = 0;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    public void suspend() {
        try {
            this.g = 2;
            this.a.suspend();
            this.g = 64;
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
    }

    public void setCurrentCulture(CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("value");
        }
        this.b = cultureInfo;
    }

    public CultureInfo getCurrentCulture() {
        if (this.b == null) {
            this.b = CultureInfo.DEFAULT_CULTURE == null ? CultureInfo.fromJava(Locale.getDefault()) : CultureInfo.DEFAULT_CULTURE;
        }
        return this.b;
    }

    public void setCurrentUICulture(CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("value");
        }
        this.c = cultureInfo;
    }

    public CultureInfo getCurrentUICulture() {
        if (this.c == null) {
            this.c = CultureInfo.getCurrentCulture();
        }
        return this.c;
    }

    public ExecutionContext get_ExecutionContext() {
        ExecutionContext executionContext = m.get();
        if (executionContext == null) {
            executionContext = new ExecutionContext();
            m.set(executionContext);
        }
        return executionContext;
    }

    public CompressedStack getCompressedStack() {
        CompressedStack compressedStack = this.get_ExecutionContext().getSecurityContext().getCompressedStack();
        return compressedStack == null || compressedStack.a() ? null : compressedStack.createCopy();
    }

    public void setCompressedStack(CompressedStack compressedStack) {
        this.get_ExecutionContext().getSecurityContext().setCompressedStack(compressedStack);
    }

    public int get_ApartmentState() {
        return this.d;
    }

    public void set_ApartmentState(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new ArgumentException("value");
        }
        this.d = n2;
    }

    public boolean get_IsAlive() {
        return this.a.isAlive() && !this.a.isInterrupted();
    }

    public boolean get_IsBackground() {
        if ((this.get_ThreadState() & 0x10) != 16) {
            return this.a.isDaemon();
        }
        throw new ThreadStateException();
    }

    public void set_IsBackground(boolean bl2) {
        try {
            this.a.setDaemon(bl2);
            if (bl2) {
                this.g |= 4;
            } else if ((this.g & 4) == 4) {
                this.g ^= 4;
            }
        }
        catch (java.lang.SecurityException securityException) {
            throw new SecurityException(securityException.getMessage());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new ThreadStateException(illegalThreadStateException.getMessage());
        }
    }

    public boolean get_IsThreadPoolThread() {
        return false;
    }

    public long get_ManagedThreadId() {
        return this.a.getId();
    }

    public String get_Name() {
        return this.f;
    }

    public void set_Name(String string) {
        if (this.e) {
            throw new InvalidOperationException("This property has already been set and cannot be modified.");
        }
        if (string != null) {
            this.a.setName(string);
        }
        this.f = string;
        this.e = true;
    }

    public int get_Priority() {
        int n2 = this.a.getPriority();
        switch (n2) {
            case 9: 
            case 10: {
                return 4;
            }
            case 7: 
            case 8: {
                return 3;
            }
            default: {
                return 2;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 1: 
            case 2: 
        }
        return 0;
    }

    public void set_Priority(int n2) {
        if (n2 < 0 || n2 > 4) {
            throw new ArgumentException("value");
        }
        this.a.setPriority(n2 * 2 + 2);
    }

    public int get_ThreadState() {
        if (!this.a.isAlive()) {
            if (this.a.isInterrupted()) {
                return 16;
            }
            if ((this.g & 8) != 8) {
                return 16;
            }
        }
        return this.g;
    }

    @Override
    public void getIDsOfNames(Guid[] guidArray, IntPtr intPtr, long l2, long l3, IntPtr intPtr2) {
    }

    @Override
    public void getTypeInfo(long l2, long l3, IntPtr intPtr) {
    }

    @Override
    public void getTypeInfoCount(long[] lArray) {
    }

    @Override
    public void invoke(long l2, Guid[] guidArray, long l3, short s2, IntPtr intPtr, IntPtr intPtr2, IntPtr intPtr3, IntPtr intPtr4) {
    }
}

