/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security;

import com.aspose.html.utils.ms.System.AppDomain;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Reflection.Assembly;
import com.aspose.html.utils.ms.System.Reflection.MethodInfo;
import com.aspose.html.utils.ms.System.Security.PermissionSet;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.lang.Struct;

public class SecurityFrame
extends Struct<SecurityFrame> {
    private AppDomain b = AppDomain.getCurrentDomain();
    private MethodInfo c;
    private PermissionSet d;
    private PermissionSet e;
    private PermissionSet f;

    public SecurityFrame() {
        this.c = null;
        this.d = new PermissionSet();
        this.e = new PermissionSet();
        this.f = new PermissionSet();
    }

    public SecurityFrame(StackTraceElement stackTraceElement) {
        Type type = Type.getType(stackTraceElement.getClassName());
        this.c = type.getMethod(stackTraceElement.getMethodName());
        this.d = new PermissionSet();
        this.e = new PermissionSet();
        this.f = new PermissionSet();
    }

    public Assembly getAssembly() {
        return this.c.getReflectedType().getAssembly();
    }

    public AppDomain getDomain() {
        return this.b;
    }

    public MethodInfo getMethod() {
        return this.c;
    }

    public PermissionSet getAssert() {
        return this.d;
    }

    public PermissionSet getDeny() {
        return this.e;
    }

    public PermissionSet getPermitOnly() {
        return this.f;
    }

    public boolean hasStackModifiers() {
        return this.d != null || this.e != null || this.f != null;
    }

    public boolean equals(SecurityFrame securityFrame) {
        if (!ObjectExtensions.referenceEquals(this.b, securityFrame.getDomain())) {
            return false;
        }
        if (!StringExtensions.equals(this.getAssembly().toString(), securityFrame.getAssembly().toString())) {
            return false;
        }
        if (!StringExtensions.equals(this.getMethod().toString(), securityFrame.getMethod().toString())) {
            return false;
        }
        if (this.d != null && !this.d.equals(securityFrame.getAssert())) {
            return false;
        }
        if (this.e != null && !this.e.equals(securityFrame.getDeny())) {
            return false;
        }
        return this.f == null || this.f.equals(securityFrame.getPermitOnly());
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.appendFormat("Frame: {0}{1}", this.c, Environment.NewLine);
        msStringBuilder2.appendFormat("\tAppDomain: {0}{1}", this.getDomain(), Environment.NewLine);
        msStringBuilder2.appendFormat("\tAssembly: {0}{1}", this.getAssembly(), Environment.NewLine);
        if (this.d != null) {
            msStringBuilder2.appendFormat("\tAssert: {0}{1}", this.d, Environment.NewLine);
        }
        if (this.e != null) {
            msStringBuilder2.appendFormat("\tDeny: {0}{1}", this.e, Environment.NewLine);
        }
        if (this.f != null) {
            msStringBuilder2.appendFormat("\tPermitOnly: {0}{1}", this.f, Environment.NewLine);
        }
        return msStringBuilder2.toString();
    }

    public static ArrayList getStack(int n2) {
        StackTraceElement stackTraceElement;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[i2]) != null; ++i2) {
            arrayList.addItem(new SecurityFrame(stackTraceElement));
        }
        return arrayList;
    }

    @Override
    public void CloneTo(SecurityFrame securityFrame) {
        securityFrame.b = this.b;
        securityFrame.c = this.c;
        securityFrame.d = this.d;
        securityFrame.e = this.e;
        securityFrame.f = this.f;
    }

    @Override
    public SecurityFrame Clone() {
        SecurityFrame securityFrame = new SecurityFrame();
        this.CloneTo(securityFrame);
        return securityFrame;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(SecurityFrame securityFrame) {
        return ObjectExtensions.equals(securityFrame.b, this.b) && ObjectExtensions.equals(securityFrame.c, this.c) && ObjectExtensions.equals(securityFrame.d, this.d) && ObjectExtensions.equals(securityFrame.e, this.e) && ObjectExtensions.equals(securityFrame.f, this.f);
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof SecurityFrame)) {
            return false;
        }
        return this.a((SecurityFrame)object);
    }

    public static boolean equals(SecurityFrame securityFrame, SecurityFrame securityFrame2) {
        return securityFrame.equals(securityFrame2);
    }

    public int hashCode() {
        int n2 = this.b != null ? this.b.hashCode() : 0;
        n2 = 31 * n2 + (this.c != null ? this.c.hashCode() : 0);
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
        n2 = 31 * n2 + (this.f != null ? this.f.hashCode() : 0);
        return n2;
    }
}

