/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.lang.Operators;

public class X509Extension
extends AsnEncodedData {
    private boolean a;

    protected X509Extension() {
    }

    public X509Extension(AsnEncodedData asnEncodedData, boolean bl2) {
        if (asnEncodedData == null) {
            throw new NullReferenceException();
        }
        if (asnEncodedData.getOid() == null) {
            throw new ArgumentNullException("encodedExtension.Oid");
        }
        this.setOid(asnEncodedData.getOid());
        this.setRawData(asnEncodedData.getRawData());
        this.a = bl2;
    }

    public X509Extension(Oid oid, byte[] byArray, boolean bl2) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        this.setOid(oid);
        this.setRawData(byArray);
        this.a = bl2;
    }

    public X509Extension(String string, byte[] byArray, boolean bl2) {
        super(string, byArray);
        this.a = bl2;
    }

    public boolean getCritical() {
        return this.a;
    }

    public void setCritical(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Expected a X509Extension instance.", new Object[0]));
        }
        super.copyFrom(asnEncodedData);
        this.a = x509Extension.getCritical();
    }

    public String formatUnkownData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            msStringBuilder2.append(ByteExtensions.toString(byArray[i2], "X2"));
        }
        return msStringBuilder2.toString();
    }
}

