/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.IO;

import com.aspose.html.utils.abY;
import com.aspose.html.utils.aca;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.IO.DirectoryInfo;
import com.aspose.html.utils.ms.System.IO.File;
import com.aspose.html.utils.ms.System.IO.FileNotFoundException;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.IO.FileSystemInfo;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;

public final class FileInfo
extends FileSystemInfo {
    private boolean b;

    public FileInfo(String string) {
        if (string == null) {
            throw new ArgumentNullException("fileName");
        }
        this.checkPath(string);
        this.OriginalPath = string;
        this.FullPath = Path.getFullPath(string);
    }

    @Override
    public boolean exists() {
        return new java.io.File(this.FullPath).exists();
    }

    @Override
    public String getName() {
        return Path.getFileName(this.FullPath);
    }

    public long getLength() {
        if (!this.exists()) {
            throw new FileNotFoundException(StringExtensions.concat("Could not find file \"", this.OriginalPath, "\"."), this.OriginalPath);
        }
        java.io.File file = new java.io.File(this.FullPath);
        return file.length();
    }

    public String getDirectoryName() {
        return Path.getDirectoryName(this.FullPath);
    }

    public DirectoryInfo getDirectory() {
        return new DirectoryInfo(this.getDirectoryName());
    }

    public abY openText() {
        return new abY(this.open(3, 1));
    }

    public aca createText() {
        return new aca(this.open(2, 2));
    }

    public aca appendText() {
        return new aca(this.open(6, 2));
    }

    public FileStream create() {
        return File.create(this.FullPath);
    }

    public FileStream openRead() {
        return this.open(3, 1, 1);
    }

    public FileStream openWrite() {
        return this.open(4, 2);
    }

    public FileStream open(int n2) {
        return this.open(n2, 3);
    }

    public FileStream open(int n2, int n3) {
        return this.open(n2, n3, 0);
    }

    public FileStream open(int n2, int n3, int n4) {
        java.io.File file = new java.io.File(this.FullPath);
        if (file.exists() && file.isDirectory()) {
            throw new FileNotFoundException(this.FullPath);
        }
        return new FileStream(this.FullPath, n2, n3, n4);
    }

    @Override
    public void delete() {
        File.delete(this.FullPath);
    }

    public void moveTo(String string) {
        if (string == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (StringExtensions.equals(string, this.getName()) || StringExtensions.equals(string, this.getFullName())) {
            return;
        }
        if (!File.exists(this.FullPath)) {
            throw new FileNotFoundException();
        }
        File.move(this.FullPath, string);
        this.FullPath = Path.getFullPath(string);
    }

    public FileInfo copyTo(String string) {
        return this.copyTo(string, false);
    }

    public FileInfo copyTo(String string, boolean bl2) {
        if (string == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (string.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("An empty file name is not valid.");
        }
        String string2 = Path.getFullPath(string);
        if (bl2 && File.exists(string2)) {
            File.delete(string2);
        }
        File.copy(this.FullPath, string2);
        return new FileInfo(string2);
    }

    public String toString() {
        return this.OriginalPath;
    }

    public FileInfo replace(String string, String string2) {
        String string3 = null;
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        if (string == null) {
            throw new ArgumentNullException("destinationFileName");
        }
        if (string.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destinationFileName");
        }
        string3 = Path.getFullPath(string);
        if (!File.exists(string3)) {
            throw new FileNotFoundException();
        }
        if (string2 != null) {
            if (string2.length() == 0) {
                throw new ArgumentException("An empty file name is not valid.", "destinationBackupFileName");
            }
            File.copy(string3, Path.getFullPath(string2), true);
        }
        File.copy(this.FullPath, string3, true);
        File.delete(this.FullPath);
        return new FileInfo(string3);
    }

    public FileInfo replace(String string, String string2, boolean bl2) {
        return this.replace(string, string2);
    }
}

