/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.ComponentModel.InvalidEnumArgumentException;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.CustomLineCap;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.HatchBrush;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.LinearGradientBrush;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.PathGradientBrush;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.SolidBrush;
import com.aspose.html.utils.ms.System.Drawing.StrokeFactory;
import com.aspose.html.utils.ms.System.Drawing.TextureBrush;
import com.aspose.html.utils.ms.System.ICloneable;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.OutOfMemoryException;
import com.aspose.html.utils.ms.core.System.Drawing.Drawing2D.MatrixUtil;
import com.aspose.html.utils.ms.lang.Ref;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public final class Pen
implements IDisposable,
ICloneable,
Stroke,
Cloneable {
    static float[] a = new float[]{1.0f, 1.0f};
    static float[] b = new float[]{3.0f, 1.0f};
    static float[] c = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static float[] d = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] h = new float[0];
    boolean e = true;
    private Brush i;
    private int j;
    private int k;
    private int l;
    private int m;
    CustomLineCap f;
    CustomLineCap g;
    private int n;
    private int o;
    private Matrix p;
    private float q;
    private float r;
    private Ref<float[]> s;
    private float t;
    private boolean u = false;

    public Pen(Brush brush) {
        this(brush, 1.0f);
    }

    public Pen(Color color) {
        this(color.Clone(), 1.0f);
    }

    public Pen(Color color, float f2) {
        this(new SolidBrush(color.Clone()), f2);
    }

    public Pen(Brush brush, float f2) {
        if (brush == null) {
            throw new ArgumentNullException("Value of 'brush' cannot be null");
        }
        this.i = Pen.a(brush);
        this.q = f2;
        this.j = 0;
        this.l = 0;
        this.k = 0;
        this.m = 0;
        this.o = 0;
        this.n = 0;
        this.t = 10.0f;
        this.p = new Matrix();
    }

    private static float[] a(int n2) {
        switch (n2) {
            case 0: {
                return new float[0];
            }
            case 3: {
                return c;
            }
            case 4: {
                return d;
            }
            case 2: {
                return a;
            }
            case 1: {
                return b;
            }
            case 5: {
                return new float[0];
            }
        }
        throw new RuntimeException();
    }

    private void b(int n2) {
        switch (n2) {
            case 0: {
                this.s = new Ref<float[]>(new float[0]);
                break;
            }
            case 3: {
                this.s = new Ref<float[]>(c);
                break;
            }
            case 4: {
                this.s = new Ref<float[]>(d);
                break;
            }
            case 2: {
                this.s = new Ref<float[]>(a);
                break;
            }
            case 1: {
                this.s = new Ref<float[]>(b);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.j = n2;
    }

    public int getAlignment() {
        return this.o;
    }

    public void setAlignment(int n2) {
        this.d();
        if (n2 < 0 || n2 > 4) {
            throw new InvalidEnumArgumentException("alignment value");
        }
        if (this.u) {
            throw new ArgumentException("Pen is already disposed");
        }
        this.o = n2;
    }

    public Brush getBrush() {
        return (Brush)this.i.deepClone();
    }

    public void setBrush(Brush brush) {
        this.d();
        if (brush == null) {
            throw new ArgumentNullException("brush");
        }
        this.i = brush;
    }

    private static Brush a(Brush brush) {
        if (brush instanceof SolidBrush) {
            return ((SolidBrush)brush).exactCopy();
        }
        if (brush instanceof HatchBrush) {
            return (Brush)((HatchBrush)brush).deepClone();
        }
        return (Brush)brush.deepClone();
    }

    private static Color b(Brush brush) {
        if (brush instanceof SolidBrush) {
            return ((SolidBrush)brush).getColor();
        }
        if (brush instanceof HatchBrush) {
            return ((HatchBrush)brush).getForegroundColor();
        }
        return Color.Empty.Clone();
    }

    public Color getColor() {
        return Pen.b(this.i);
    }

    public void setColor(Color color) {
        this.d();
        this.i = new SolidBrush(color.Clone());
    }

    public float[] getCompoundArray() {
        return this.h;
    }

    public void setCompoundArray(float[] fArray) {
        if (fArray == null) {
            throw new NullReferenceException();
        }
        if (fArray.length == 0 || fArray.length % 2 == 1) {
            throw new ArgumentException();
        }
        float f2 = 0.0f;
        for (float f3 : fArray) {
            if (f3 < f2 || f3 > 1.0f) {
                throw new ArgumentException();
            }
            f2 = f3;
        }
        this.h = new float[fArray.length];
        Array.copy(Array.boxing(fArray), 0, Array.boxing(this.h), 0, fArray.length);
    }

    private CustomLineCap b() {
        return this.f != null ? (CustomLineCap)this.f.deepClone() : null;
    }

    private CustomLineCap c() {
        return this.g != null ? (CustomLineCap)this.g.deepClone() : null;
    }

    public CustomLineCap getCustomEndCap() {
        if (this.g == null) {
            throw new ArgumentException("customEndCap member is null");
        }
        return this.c();
    }

    public void setCustomEndCap(CustomLineCap customLineCap) {
        if (customLineCap == null) {
            throw new ArgumentException("Parameter 'value' cannot be null");
        }
        if (!this.e) {
            throw new ArgumentException("Pen object is immutable");
        }
        this.setEndCap(255);
        this.g = (CustomLineCap)customLineCap.deepClone();
    }

    public CustomLineCap getCustomStartCap() {
        if (this.f == null) {
            throw new ArgumentException("customStartCap member is null");
        }
        return this.b();
    }

    public void setCustomStartCap(CustomLineCap customLineCap) {
        if (customLineCap == null) {
            throw new ArgumentException("Parameter 'value' cannot be null");
        }
        if (!this.e) {
            throw new ArgumentException("Pen object is immutable");
        }
        this.setStartCap(255);
        this.f = (CustomLineCap)customLineCap.deepClone();
    }

    public CustomLineCap[] getCustomCaps() {
        return new CustomLineCap[]{this.b(), this.c()};
    }

    public int getDashCap() {
        return this.k;
    }

    public void setDashCap(int n2) {
        if (n2 != 0 && n2 != 2 && n2 != 3) {
            throw new InvalidEnumArgumentException("DashCap value");
        }
        this.d();
        this.k = n2;
    }

    public float getDashOffset() {
        return this.r;
    }

    public void setDashOffset(float f2) {
        this.d();
        this.r = f2;
    }

    public float[] getDashPattern() {
        if (this.s == null) {
            throw new OutOfMemoryException("dashPattern");
        }
        return (float[])((float[])this.s.value).clone();
    }

    public void setDashPattern(float[] fArray) {
        this.d();
        if (fArray == null || fArray.length == 0) {
            throw new ArgumentException("Argument 'value' is invalid");
        }
        for (float f2 : fArray) {
            if (!(f2 <= 0.0f)) continue;
            throw new ArgumentException("Parameter is invalid");
        }
        this.j = 5;
        this.s = new Ref<float[]>(fArray);
    }

    public int getDashStyle() {
        return this.j;
    }

    public void setDashStyle(int n2) {
        if (n2 < 0 || n2 > 5) {
            throw new InvalidEnumArgumentException("DashStyle value");
        }
        this.d();
        this.b(n2);
        if (n2 == 5 && (this.s == null || this.s.value == null || ((float[])this.s.value).length == 0)) {
            this.s = new Ref<float[]>(new float[]{1.0f});
        }
    }

    public int getStartCap() {
        return this.l;
    }

    public void setStartCap(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 240: 
            case 255: {
                break;
            }
            default: {
                throw new InvalidEnumArgumentException("StartCap value");
            }
        }
        this.d();
        this.f = null;
        this.l = n2;
    }

    public int getEndCap() {
        return this.m;
    }

    public void setEndCap(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 240: 
            case 255: {
                break;
            }
            default: {
                throw new InvalidEnumArgumentException("EndCap value");
            }
        }
        this.d();
        this.g = null;
        this.m = n2;
    }

    public int getLineJoin() {
        return this.n;
    }

    public void setLineJoin(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new InvalidEnumArgumentException("LineJoin");
        }
        this.d();
        this.n = n2;
    }

    public float getMiterLimit() {
        return this.t;
    }

    public void setMiterLimit(float f2) {
        this.d();
        this.t = f2 < 1.0f ? 1.0f : f2;
    }

    public int getPenType() {
        if (this.getBrush() instanceof TextureBrush) {
            return 2;
        }
        if (this.getBrush() instanceof HatchBrush) {
            return 1;
        }
        if (this.getBrush() instanceof LinearGradientBrush) {
            return 4;
        }
        if (this.getBrush() instanceof PathGradientBrush) {
            return 3;
        }
        return 0;
    }

    public Matrix getTransform() {
        return this.p.deepClone();
    }

    public void setTransform(Matrix matrix) {
        this.d();
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'value' cannot be null");
        }
        if (!matrix.isInvertible()) {
            throw new ArgumentException("Matrix 'value' must be invertible");
        }
        matrix.copyTo(this.p);
    }

    public float getWidth() {
        return this.q;
    }

    public float getEffectiveWidth() {
        return this.q < 0.0f ? 0.0f : this.q;
    }

    public void setWidth(float f2) {
        this.d();
        this.q = f2;
    }

    @Override
    public Object deepClone() {
        Pen pen = (Pen)this.memberwiseClone();
        if (pen.p != null) {
            pen.p = pen.p.deepClone();
        }
        if (pen.s != null && pen.s.value != null) {
            pen.s.value = ((float[])pen.s.value).clone();
        }
        pen.e = true;
        return pen;
    }

    public Pen cloneWithoutCustomCap() {
        Pen pen = (Pen)this.deepClone();
        if (pen.getEndCap() == 255 || pen.g != null) {
            pen.setEndCap(0);
            pen.g = null;
        }
        if (pen.getStartCap() == 255 || pen.f != null) {
            pen.setStartCap(0);
            pen.f = null;
        }
        return pen;
    }

    @Override
    public void dispose() {
        this.a(true);
    }

    private void a(boolean bl2) {
        if (!this.e && bl2) {
            throw new ArgumentException("You may not change this Pen because it does not belong to you.");
        }
        this.u = true;
        if (!bl2) {
            this.e = true;
        }
    }

    public void multiplyTransform(Matrix matrix) {
        this.multiplyTransform(matrix, 0);
    }

    public void multiplyTransform(Matrix matrix, int n2) {
        if (n2 != 0) {
            n2 = 1;
        }
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        if (!matrix.isInvertible()) {
            throw new ArgumentException("Parameter is not valid");
        }
        this.p.multiply(matrix, n2);
    }

    public void resetTransform() {
        this.p.reset();
    }

    public void rotateTransform(float f2) {
        this.p.rotate(f2);
    }

    public void rotateTransform(float f2, int n2) {
        this.p.rotate(f2, n2);
    }

    public void scaleTransform(float f2, float f3) {
        this.p.scale(f2, f3);
    }

    public void scaleTransform(float f2, float f3, int n2) {
        this.p.scale(f2, f3, n2);
    }

    public void translateTransform(float f2, float f3) {
        this.p.translate(f2, f3);
    }

    public void translateTransform(float f2, float f3, int n2) {
        this.p.translate(f2, f3, n2);
    }

    public void setLineCap(int n2, int n3, int n4) {
        if (!this.e) {
            throw new ArgumentException("Pen is not modifiable");
        }
        this.l = n2;
        this.m = n3;
        if (n4 == 2 || n4 == 3) {
            this.setDashCap(n4);
        } else {
            this.setDashCap(0);
        }
    }

    private void d() {
        if (!this.e) {
            throw new ArgumentException("You may not change this Pen because it does not belong to you.");
        }
    }

    double a(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.p.getNativeObject();
        double d2 = affineTransform2.getScaleX();
        double d3 = affineTransform2.getShearY();
        double d4 = affineTransform2.getShearX();
        double d5 = affineTransform2.getScaleY();
        double d6 = affineTransform.getScaleX();
        double d7 = affineTransform.getShearY();
        double d8 = affineTransform.getShearX();
        double d9 = affineTransform.getScaleY();
        double d10 = d2 * d5;
        double d11 = d3 * d4;
        double d12 = d6 * d9;
        double d13 = d7 * d8;
        double d14 = d12 - d13;
        return Math.abs((double)(this.getWidth() * this.getWidth()) * (d10 * d14 - d11 * d14));
    }

    boolean a() {
        return this.p.isIdentity();
    }

    Stroke a(AffineTransform affineTransform, int n2) {
        return this.a(null, affineTransform, n2, false, false, false, null);
    }

    Stroke a(AffineTransform affineTransform, int n2, Graphics graphics) {
        return this.a(null, affineTransform, n2, false, false, true, graphics);
    }

    Stroke a(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2) {
        return this.a(affineTransform, affineTransform2, n2, bl2, false, true, null);
    }

    Stroke b(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2) {
        return this.a(affineTransform, affineTransform2, n2, bl2, false, false, null);
    }

    Stroke a(AffineTransform affineTransform, AffineTransform affineTransform2, int n2, boolean bl2, boolean bl3, boolean bl4, Graphics graphics) {
        Object object = null;
        int n3 = this.getDashCap();
        float f2 = this.getDashOffset();
        switch (this.getDashStyle()) {
            case 5: {
                if (this.s == null) break;
                object = ((float[])this.s.value).length == 1 ? null : (((float[])this.s.value).length % 2 != 0 ? new float[((float[])this.s.value).length + 1] : new float[((float[])this.s.value).length]);
                float f3 = (double)this.getWidth() < 1.0 ? 1.0f : this.getWidth();
                f2 *= f3;
                if (object == null) break;
                int n4 = 0;
                int n5 = 0;
                while (n4 < ((float[])this.s.value).length) {
                    object[n5] = this.getDashCap() == 2 ? Math.max(1.0f, ((float[])this.s.value)[n4]) * f3 : ((float[])this.s.value)[n4] * f3;
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 1: {
                object = new float[b.length];
                for (int i2 = 0; i2 < ((float[])object).length; ++i2) {
                    object[i2] = b[i2] * this.getEffectiveWidth();
                }
                break;
            }
            case 3: {
                object = new float[c.length];
                for (int i3 = 0; i3 < ((float[])object).length; ++i3) {
                    object[i3] = c[i3] * this.getEffectiveWidth();
                }
                break;
            }
            case 4: {
                object = new float[d.length];
                for (int i4 = 0; i4 < ((float[])object).length; ++i4) {
                    object[i4] = d[i4] * this.getEffectiveWidth();
                }
                break;
            }
            case 2: {
                object = new float[a.length];
                for (int i5 = 0; i5 < ((float[])object).length; ++i5) {
                    object[i5] = a[i5] * this.getEffectiveWidth();
                }
                break;
            }
            case 0: {
                n3 = 0;
            }
        }
        int n6 = this.getLineJoin();
        AffineTransform affineTransform3 = this.p.getNativeObject();
        if (bl2) {
            affineTransform3 = this.getDotNetScalingByMatrix(this.p).getNativeObject();
        }
        float f4 = this.getWidth() <= 0.0f ? 1.0f : this.getWidth();
        return bl3 ? StrokeFactory.a(f4, this.getStartCap(), this.getEndCap(), n6, this.getMiterLimit(), object, f2, affineTransform3, affineTransform2, n2) : StrokeFactory.a(f4, this.getStartCap(), this.getEndCap(), n6, this.getMiterLimit(), object, f2, n3, affineTransform3, affineTransform2, n2, graphics);
    }

    public Matrix getDotNetScalingByMatrix(Matrix matrix) {
        float[] fArray = MatrixUtil.getOriginalScalingCoeff(matrix);
        double d2 = fArray[0];
        double d3 = fArray[1];
        double d4 = Math.abs(d2);
        double d5 = Math.abs(d3);
        if (d4 < 1.0 && d4 > 0.0) {
            d2 = 1.0 / ((double)this.getWidth() * d2);
        }
        if (d5 < 1.0 && d5 > 0.0) {
            d3 = 1.0 / ((double)this.getWidth() * d3);
        }
        float[] fArray2 = matrix.getElements();
        return new Matrix((float)d3, fArray2[1], fArray2[2], (float)d2, fArray2[4], fArray2[5]);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        return this.a(null, 0).createStrokedShape(shape);
    }

    public Shape createWidenShape(Shape shape) {
        return this.a(null, null, 0, false, true, false, null).createStrokedShape(shape);
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

