/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Drawing.FontFamily;
import com.aspose.html.utils.ms.System.Drawing.FontStyle;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Text.FontCollection;
import com.aspose.html.utils.ms.System.Drawing.Text.InstalledFontCollection;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.ICloneable;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.System.Drawing.GraphicsUtils;
import com.aspose.html.utils.ms.lang.Ref;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;

public final class Font
implements IDisposable,
ICloneable,
Cloneable {
    private static final char b = '\u0000';
    private static final char c = '\u0001';
    private static final char d = '\u0002';
    private static final char e = '\u0080';
    private static final char f = '\u0081';
    private static final char g = '\u0081';
    private static final char h = '\u0086';
    private static final char i = '\u0088';
    private static final char j = '\u00ff';
    private static final char k = '\u0082';
    private static final char l = '\u00b1';
    private static final char m = '\u00b2';
    private static final char n = '\u00a1';
    private static final char o = '\u00a2';
    private static final char p = '\u00a3';
    private static final char q = '\u00de';
    private static final char r = '\u00ee';
    private static final char s = '\u00cc';
    private static final char t = 'M';
    private static final char u = '\u00ba';
    private int v = 3;
    private final FontFamily w;
    private String x = null;
    private float y = 0.0f;
    private java.awt.Font z;
    private char A = '\u0001';
    private boolean B = false;
    private final Map<TextAttribute, Object> C = new HashMap<TextAttribute, Object>();
    static float[] a = new float[]{1.0f, 1.0f, 1.0f, GraphicsUtils.getDefaultScreenResolution(), GraphicsUtils.getDefaultScreenResolution(), GraphicsUtils.getDefaultScreenResolution(), GraphicsUtils.getDefaultScreenResolution()};
    private String D;
    private boolean E = false;

    private Font(java.awt.Font font) {
        this.z = font;
        this.w = Font.a(font.getFamily());
        this.y = GraphicsUtils.unitConversion(2, 3, font.getSize());
        this.x = this.z.getName();
    }

    public java.awt.Font getNativeObject() {
        if (this.E) {
            throw new ArgumentException("Parameter is invalid");
        }
        return this.z;
    }

    public Font(Font font, int n2) {
        this.z = font.getNativeObject().deriveFont(Font.deriveStyle(font.getNativeObject().getAttributes(), n2, true));
        this.v = font.v;
        this.w = font.w;
        this.A = font.A;
        this.x = font.getName();
        this.B = font.getGdiVerticalFont();
        this.y = font.y;
    }

    static Font a(Font font, int n2, float f2) {
        Font font2 = (Font)font.deepClone();
        double d2 = 0.0;
        if (GraphicsUtils.unitPixelOrDisplay(n2)) {
            font2.y = GraphicsUtils.changeUnitOfValue(2, font.getUnit(), f2, font2.z.getSize());
            d2 = font2.y;
        } else if (n2 == 3) {
            if (GraphicsUtils.unitPixelOrDisplay(font.getUnit())) {
                d2 = GraphicsUtils.changeUnitOfValue(2, n2, f2, font2.z.getSize());
                font2.y = (float)d2;
            } else {
                Font font3 = new Font(font2.getName(), font2.getSize(), 0);
                d2 = GraphicsUtils.changeUnitOfValue(font.getUnit(), 2, f2, font3.getSizeInPoints());
                font2.y = (float)d2;
            }
        } else if (n2 == 6) {
            if (GraphicsUtils.unitPixelOrDisplay(font.getUnit())) {
                d2 = GraphicsUtils.changeUnitOfValue(2, n2, f2, font2.z.getSize());
                font2.y = (float)d2;
            } else if (font.getUnit() == 6) {
                d2 = GraphicsUtils.changeUnitOfValue(2, n2, f2, font2.getSize());
                font2.y = (float)d2;
            } else if (font.getUnit() == 3) {
                Font font4 = new Font(font2.getName(), font2.getSize(), 0);
                d2 = GraphicsUtils.changeUnitOfValue(2, 3, GraphicsUtils.getSystemDpiY(), font4.getSizeInPoints());
                font2.y = (float)d2;
            }
        } else if (n2 == 5) {
            if (GraphicsUtils.unitPixelOrDisplay(font.getUnit())) {
                d2 = GraphicsUtils.changeUnitOfValue(2, n2, f2, font2.z.getSize());
                font2.y = (float)d2;
            } else if (font.getUnit() == 3) {
                Font font5 = new Font(font2.getName(), font2.getSize(), 0);
                d2 = GraphicsUtils.changeUnitOfValue(6, n2, f2, font2.getSize());
                font2.y = (float)d2;
            } else if (font.getUnit() == 6) {
                Font font6 = new Font(font2.getName(), font2.getSize(), 0);
                font2.y = GraphicsUtils.unitConversion(2, 6, font6.getSizeInPoints() * GraphicsUtils.getSystemDpiY());
            }
        } else {
            d2 = GraphicsUtils.unitConversion(2, n2, font2.z.getSize());
            font2.y = GraphicsUtils.unitConversion(2, font.getUnit(), (float)d2);
        }
        font2.C.put(TextAttribute.SIZE, new Float(d2));
        font2.z = font2.w.a().deriveFont(font2.C);
        return font2;
    }

    float a() {
        if (this.v == 6) {
            return this.getSize();
        }
        float f2 = GraphicsUtils.unitConversion(6, 4, GraphicsUtils.getSystemDpiY());
        float f3 = (float)((double)this.getHeight(GraphicsUtils.getSystemDpiY()) / (double)this.b());
        float f4 = f3 / f2;
        return f4;
    }

    static Font a(Graphics graphics, Font font) {
        return Font.a(graphics, font, graphics.getPageUnit());
    }

    static Font a(Graphics graphics, Font font, int n2) {
        Font font2 = (Font)font.deepClone();
        float f2 = font2.y;
        int n3 = font.getUnit();
        int n4 = n2;
        double d2 = f2;
        d2 = GraphicsUtils.changeUnitOfValueOld(n3, n4, graphics.getDpiY(), f2);
        float f3 = (float)d2;
        font2.C.put(TextAttribute.SIZE, new Float(f3));
        font2.z = font2.w.a().deriveFont(font2.C);
        font2.y = f3;
        font2.v = graphics.getPageUnit();
        return font2;
    }

    public Font(FontFamily fontFamily, float f2) {
        this(fontFamily, f2, 0, 3, '\u0001', false);
    }

    private Font(FontFamily fontFamily, float f2, Ref<Integer> ref) {
        this(fontFamily, f2, (int)((Integer)ref.value), 3, '\u0001', false);
    }

    private Font(FontFamily fontFamily, float f2, int n2) {
        this(fontFamily, f2, 0, n2, '\u0001', false);
    }

    public Font(FontFamily fontFamily, float f2, int n2, int n3) {
        this(fontFamily, f2, n2, n3, '\u0001', false);
    }

    public Font(FontFamily fontFamily, float f2, int n2, int n3, char c2) {
        this(fontFamily, f2, n2, n3, c2, false);
    }

    public Font(FontFamily fontFamily, float f2, int n2, int n3, char c2, boolean bl2) {
        if (fontFamily == null) {
            throw new ArgumentNullException("family");
        }
        this.w = fontFamily;
        this.a(this.w.getName(), this.w.a(), f2, n2, n3, c2, bl2, false);
    }

    static java.awt.Font a(String object, float f2, FontCollection fontCollection) {
        Object object2;
        java.awt.Font font = fontCollection.getInitialFont((String)object);
        if (font == null) {
            object2 = FontFamily.a(1);
            font = new InstalledFontCollection().getInitialFont((String)object2);
            object = object2;
        }
        object2 = new int[]{3};
        char[] cArray = new char[]{'\u0001'};
        boolean[] blArray = new boolean[]{false};
        HashMap[] hashMapArray = new HashMap[]{null};
        float[] fArray = new float[]{f2};
        java.awt.Font[] fontArray = new java.awt.Font[]{null};
        String[] stringArray = new String[]{object};
        try {
            Font.a((String)object, font, f2, 0, 3, '\u0001', false, (int[])object2, cArray, blArray, hashMapArray, fArray, fontArray, stringArray);
        }
        catch (ArgumentException argumentException) {
            return Font.a(FontFamily.a(1), f2, fontCollection);
        }
        return fontArray[0];
    }

    private static void a(String string, java.awt.Font font, float f2, int n2, int n3, char c2, boolean bl2, int[] nArray, char[] cArray, boolean[] blArray, Map<TextAttribute, Object>[] mapArray, float[] fArray, java.awt.Font[] fontArray, String[] stringArray) {
        if (Float.isNaN(f2) || Float.isInfinite(f2) || f2 <= 0.0f) {
            throw new ArgumentException("Parameter 'emSize' is invalid");
        }
        if (n3 == 1) {
            throw new ArgumentException("Parameter 'unit' cannot be Graphics.Display");
        }
        if (!FontFamily.isStyleAvailable(string, font, n2)) {
            throw new ArgumentException("Font '" + string + "' does not support style '" + Enum.getName(FontStyle.class, n2) + "'");
        }
        nArray[0] = n3;
        cArray[0] = c2;
        blArray[0] = bl2;
        mapArray[0] = new HashMap<TextAttribute, Object>();
        mapArray[0].put(TextAttribute.FAMILY, string);
        mapArray[0].put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        mapArray[0].put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        fArray[0] = f2;
        double d2 = fArray[0];
        if (nArray[0] != 2) {
            d2 = GraphicsUtils.unitConversion(nArray[0], 2, fArray[0]);
        }
        mapArray[0].put(TextAttribute.SIZE, new Float(d2));
        Font.deriveStyle(mapArray[0], n2, false);
        fontArray[0] = font.deriveFont(mapArray[0]);
        if (!fontArray[0].getFamily().matches(string)) {
            mapArray[0].remove(TextAttribute.FAMILY);
            java.awt.Font font2 = font.deriveFont((float)d2);
            fontArray[0] = font2.deriveFont(mapArray[0]);
        }
        stringArray[0] = fontArray[0].getName();
    }

    private void a(String string, java.awt.Font font, float f2, int n2, int n3, char c2, boolean bl2, boolean bl3) {
        if (Float.isNaN(f2) || Float.isInfinite(f2) || f2 <= 0.0f) {
            throw new ArgumentException("Parameter 'emSize' is invalid");
        }
        if (n3 == 1) {
            throw new ArgumentException("Parameter 'unit' cannot be Graphics.Display");
        }
        if (!FontFamily.isStyleAvailable(string, font, n2)) {
            throw new ArgumentException("Font '" + string + "' does not support style '" + Enum.getName(FontStyle.class, n2) + "'");
        }
        this.v = n3;
        this.A = c2;
        this.B = bl2;
        this.C.put(TextAttribute.FAMILY, string);
        this.C.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        this.C.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        this.y = f2;
        double d2 = this.y;
        if (this.v != 2) {
            d2 = GraphicsUtils.unitConversion(this.v, 2, this.y);
        }
        this.C.put(TextAttribute.SIZE, new Float(d2));
        Font.deriveStyle(this.C, n2, false);
        this.z = font.deriveFont(this.C);
        String string2 = Pattern.quote(this.w.getName());
        if (!this.z.getFamily().matches(string2)) {
            this.C.remove(TextAttribute.FAMILY);
            java.awt.Font font2 = font.deriveFont((float)d2);
            this.z = font2.deriveFont(this.C);
        }
        this.x = this.z.getName();
    }

    public Font(String string, float f2) {
        this(string, f2, 0, 3, '\u0001', false);
    }

    private Font(String string, float f2, Ref<Integer> ref) {
        this(string, f2, (int)((Integer)ref.value), 3, '\u0001', false);
    }

    private Font(String string, float f2, int n2) {
        this(string, f2, 0, n2, '\u0001', Font.b(string));
    }

    public Font(String string, float f2, int n2, int n3) {
        this(string, f2, n2, n3, '\u0001', false);
    }

    public Font(String string, float f2, int n2, int n3, char c2) {
        this(string, f2, n2, n3, c2, false);
    }

    public Font(String string, float f2, int n2, int n3, char c2, boolean bl2) {
        this(Font.a(string), f2, n2, n3, c2, bl2);
    }

    public Font(String string, float f2, String string2) {
        this(string, f2);
        this.D = string2;
    }

    static FontFamily a(String string) {
        try {
            return new FontFamily(string);
        }
        catch (Exception exception) {
            return FontFamily.getGenericSansSerif();
        }
    }

    private static boolean b(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '@';
    }

    @Override
    public void dispose() {
        this.z = null;
        this.E = true;
    }

    @Override
    public Object deepClone() {
        return this.memberwiseClone();
    }

    public boolean equals(Object object) {
        Font font = object instanceof Font ? (Font)object : null;
        return font != null && this.getNativeObject().equals(font.getNativeObject());
    }

    public int hashCode() {
        return this.getNativeObject().hashCode();
    }

    public boolean getBold() {
        return this.getNativeObject().isBold();
    }

    public FontFamily getFontFamily() {
        return this.w;
    }

    public char getGdiCharSet() {
        return this.A;
    }

    public boolean getGdiVerticalFont() {
        return this.B;
    }

    public int getHeight_Rename_Namesake() {
        this.getFontFamily();
        return FontFamily.e.getFontMetrics(this.getNativeObject()).getHeight();
    }

    public float getHeight() {
        return this.getHeight(GraphicsUtils.getSystemDpiY());
    }

    public float getHeight(float f2) {
        return this.b() * GraphicsUtils.unitConversion(this.v, 4, this.y) * f2;
    }

    private float b() {
        return (float)((double)this.getFontFamily().getLineSpacing(this.getStyle()) / (double)this.getFontFamily().getEmHeight(this.getStyle()));
    }

    public float getHeight(Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("graphics");
        }
        float f2 = graphics.getDpiY();
        int n2 = graphics.getPageUnit();
        if (n2 != 2 && n2 != 1 && this.v != 2 && this.v != 0) {
            f2 = GraphicsUtils.unitConversion(2, graphics.getPageUnit(), graphics.getDpiY());
        }
        return this.getHeight(f2);
    }

    public boolean getItalic() {
        return this.getNativeObject().isItalic();
    }

    public String getName() {
        return this.x;
    }

    public float getSize() {
        return this.y;
    }

    public float getSizeInPoints() {
        if (this.v == 3) {
            return this.getSize();
        }
        float f2 = GraphicsUtils.unitConversion(3, 4, GraphicsUtils.getSystemDpiY());
        float f3 = (float)((double)this.getHeight(GraphicsUtils.getSystemDpiY()) / (double)this.b());
        float f4 = f3 / f2;
        return f4;
    }

    public boolean getStrikeout() {
        try {
            if ((Boolean)this.getNativeObject().getAttributes().get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getStyle() {
        int n2 = 0;
        if (this.getBold()) {
            n2 |= 1;
        }
        if (this.getItalic()) {
            n2 |= 2;
        }
        if (this.getUnderline()) {
            n2 |= 4;
        }
        if (this.getStrikeout()) {
            n2 |= 8;
        }
        return n2;
    }

    public boolean getUnderline() {
        try {
            if ((Integer)this.getNativeObject().getAttributes().get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getUnit() {
        return this.v;
    }

    public boolean isSystemFont() {
        return !StringExtensions.isNullOrEmpty(this.D);
    }

    public String getSystemFontName() {
        return this.D;
    }

    public String toString() {
        return StringExtensions.format(CultureInfo.getCurrentCulture(), "[{0}: Name={1}, Size={2}, Units={3}, GdiCharSet={4}, GdiVerticalFont={5}]", this.getClass().getSimpleName(), this.getFontFamily().getName(), Float.valueOf(this.getSize()), this.getUnit(), (int)this.getGdiCharSet(), this.getGdiVerticalFont());
    }

    public static Map deriveStyle(Map hashtable, int n2, boolean bl2) {
        Hashtable hashtable2;
        if (bl2) {
            hashtable2 = new Hashtable(hashtable.size());
            for (Object k2 : hashtable.keySet()) {
                Object v2 = hashtable.get(k2);
                if (v2 == null) continue;
                hashtable2.put(k2, v2);
            }
        } else {
            hashtable2 = hashtable;
        }
        if ((n2 & 1) == 1) {
            hashtable2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            hashtable2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if ((n2 & 2) == 2) {
            hashtable2.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            hashtable2.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        if ((n2 & 4) == 4) {
            hashtable2.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        } else {
            hashtable2.remove(TextAttribute.UNDERLINE);
        }
        if ((n2 & 8) == 8) {
            hashtable2.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        } else {
            hashtable2.remove(TextAttribute.STRIKETHROUGH);
        }
        return hashtable2;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    private static int a(java.awt.Font font) {
        Boolean bl2;
        Integer n2;
        Float f2;
        int n3 = 0;
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f3 = (Float)map.get(TextAttribute.WEIGHT);
        if (f3 != null && f3.floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
            n3 |= 1;
        }
        if ((f2 = (Float)map.get(TextAttribute.POSTURE)) != null && f2 == TextAttribute.POSTURE_OBLIQUE) {
            n3 |= 2;
        }
        if ((n2 = (Integer)map.get(TextAttribute.UNDERLINE)) != null && n2 == TextAttribute.UNDERLINE_ON) {
            n3 |= 4;
        }
        if ((bl2 = (Boolean)map.get(TextAttribute.STRIKETHROUGH)) != null && bl2 == TextAttribute.STRIKETHROUGH_ON) {
            n3 |= 8;
        }
        return n3;
    }

    public static java.awt.Font toJava(Font font) {
        if (font == null) {
            return null;
        }
        return font.getNativeObject();
    }

    public static Font fromJava(java.awt.Font font) {
        if (font == null) {
            return null;
        }
        return new Font(font);
    }
}

