/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.toolkit.markdown.syntax.text;

import com.aspose.html.IDisposable;
import com.aspose.html.toolkit.markdown.syntax.text.SourceTextReader;
import com.aspose.html.toolkit.markdown.syntax.text.TextLineCollection;
import com.aspose.html.toolkit.markdown.syntax.text.TextSpan;
import com.aspose.html.utils.YK;
import com.aspose.html.utils.YM;
import com.aspose.html.utils.YN;
import com.aspose.html.utils.collections.generic.IGenericEnumerable;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;

public abstract class SourceText
implements IDisposable {
    private TextLineCollection hpR;

    public abstract Encoding getEncoding();

    public abstract int getLength();

    public abstract char hQ(int var1);

    public TextSpan getSpan() {
        return new TextSpan(0, this.getLength());
    }

    public final TextLineCollection getLines_Rename_Namesake() {
        if (this.hpR == null) {
            this.hpR = TextLineCollection.a(this, this.aoo());
        }
        return this.hpR;
    }

    @Override
    public final void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public static SourceText from(String string) {
        return SourceText.from(string, Encoding.getUTF8());
    }

    public static SourceText from(String string, Encoding encoding) {
        return new YN(string, encoding);
    }

    public static SourceText from(SourceText[] sourceTextArray) {
        return new YK(sourceTextArray);
    }

    public abstract void copyTo(int var1, char[] var2, int var3, int var4);

    public final SourceText getText() {
        return this.getText(new TextSpan(0, this.getLength()));
    }

    public SourceText getText(TextSpan textSpan) {
        int n2 = textSpan.getLength();
        if (n2 == 0) {
            return SourceText.from(StringExtensions.Empty, this.getEncoding());
        }
        if (n2 == this.getLength() && textSpan.getStart() == 0) {
            return this;
        }
        return new YM(this, textSpan.aor());
    }

    public final SourceText getText(int n2) {
        if (n2 < 0 || n2 > this.getLength()) {
            throw new ArgumentOutOfRangeException("start");
        }
        if (n2 == 0) {
            return this;
        }
        return this.getText(new TextSpan(n2, this.getLength() - n2));
    }

    private IGenericEnumerable<TextSpan> aoo() {
        TextSpan textSpan;
        char c2;
        SourceText sourceText = this;
        List<TextSpan> list = new List<TextSpan>();
        SourceTextReader sourceTextReader = new SourceTextReader(sourceText);
        int n2 = sourceTextReader.getPosition();
        while ((c2 = sourceTextReader.next()) != '\u0000') {
            switch (c2) {
                case '\r': {
                    if (sourceTextReader.peek() == '\n') {
                        sourceTextReader.advance();
                    }
                    int n3 = sourceTextReader.getPosition();
                    textSpan = new TextSpan(n2, n3 - n2);
                    n2 = sourceTextReader.getPosition();
                    list.add(textSpan);
                    break;
                }
                case '\n': {
                    int n3 = sourceTextReader.getPosition();
                    textSpan = new TextSpan(n2, n3 - n2);
                    n2 = sourceTextReader.getPosition();
                    list.add(textSpan);
                    break;
                }
            }
        }
        textSpan = new TextSpan(n2, sourceTextReader.getPosition() - n2);
        if (textSpan.getLength() != 0) {
            list.add(textSpan);
        }
        return list;
    }

    public String toString() {
        return this.toString(new TextSpan(0, this.getLength()));
    }

    public final String toString(int n2) {
        if (n2 < 0 || n2 > this.getLength()) {
            throw new ArgumentOutOfRangeException("start");
        }
        return this.toString(new TextSpan(n2, this.getLength() - n2));
    }

    public final String toString(int n2, int n3) {
        return this.toString(new TextSpan(n2, n3));
    }

    public String toString(TextSpan textSpan) {
        if (textSpan.isEmpty()) {
            return StringExtensions.Empty;
        }
        int n2 = textSpan.getStart() > this.getLength() - 1 ? this.getLength() - 1 : textSpan.getStart();
        int n3 = n2 + textSpan.getLength() > this.getLength() ? this.getLength() - n2 : textSpan.getLength();
        TextSpan.create(n2, n3).c(textSpan);
        char[] cArray = new char[textSpan.getLength()];
        this.copyTo(textSpan.getStart(), cArray, 0, textSpan.getLength());
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append(cArray, 0, textSpan.getLength());
        return msStringBuilder2.toString();
    }

    protected void dispose(boolean bl2) {
    }
}

