/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.internal.Nat;
import org.bouncycastle.math.internal.Nat256;

class SecP256K1Field {
    static final int[] P = new int[]{-977, -2, -1, -1, -1, -1, -1, -1};
    static final int[] PExt = new int[]{954529, 1954, 1, 0, 0, 0, 0, 0, -1954, -3, -1, -1, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-954529, -1955, -2, -1, -1, -1, -1, -1, 1953, 2};
    private static final int P7 = -1;
    private static final int PExt15 = -1;
    private static final int PInv33 = 977;

    SecP256K1Field() {
    }

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = Nat256.add(nArray, nArray2, nArray3);
        if (n2 != 0 || nArray3[7] == -1 && Nat256.gte(nArray3, P)) {
            Nat.add33To(8, 977, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = Nat.add(16, nArray, nArray2, nArray3);
        if ((n2 != 0 || nArray3[15] == -1 && Nat.gte(16, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(16, nArray3, PExtInv.length);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n2 = Nat.inc(8, nArray, nArray2);
        if (n2 != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat256.fromBigInteger(bigInteger);
        if (nArray[7] == -1 && Nat256.gte(nArray, P)) {
            Nat256.subFrom(P, nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            int n2 = Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, n2);
        }
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        SecP256K1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = Nat256.mulAddTo(nArray, nArray2, nArray3);
        if ((n2 != 0 || nArray3[15] == -1 && Nat.gte(16, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(16, nArray3, PExtInv.length);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (Nat256.isZero(nArray)) {
            Nat256.zero(nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l2 = Nat256.mul33Add(977, nArray, 8, nArray, 0, nArray2, 0);
        int n2 = Nat256.mul33DWordAdd(977, l2, nArray2, 0);
        if (n2 != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }

    public static void reduce32(int n2, int[] nArray) {
        if (n2 != 0 && Nat256.mul33WordAdd(977, n2, nArray, 0) != 0 || nArray[7] == -1 && Nat256.gte(nArray, P)) {
            Nat.add33To(8, 977, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256K1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n2, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256K1Field.reduce(nArray3, nArray2);
        while (--n2 > 0) {
            Nat256.square(nArray2, nArray3);
            SecP256K1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = Nat256.sub(nArray, nArray2, nArray3);
        if (n2 != 0) {
            Nat.sub33From(8, 977, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = Nat.sub(16, nArray, nArray2, nArray3);
        if (n2 != 0 && Nat.subFrom(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.decAt(16, nArray3, PExtInv.length);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n2 = Nat.shiftUpBit(8, nArray, 0, nArray2);
        if (n2 != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            Nat.add33To(8, 977, nArray2);
        }
    }
}

