/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.jcajce.spec.PrfUtils;

public class PBKDF2ParameterSpec
extends PBEParameterSpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final int keySize;
    private final AlgorithmIdentifier prf;

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, defaultPRF);
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3, DigestAlgorithm digestAlgorithm) {
        this(byArray, n2, n3, PrfUtils.getAlgorithmIdentifier(digestAlgorithm));
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        super(byArray, n2);
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("keySize must be a multiple of 8");
        }
        this.keySize = n3;
        this.prf = algorithmIdentifier;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

