/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                final SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        secureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        secureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n2) {
                        return secureRandom.generateSeed(n2);
                    }
                };
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                EntropySourceProvider entropySourceProvider = bouncyCastleFipsProvider.getEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(bouncyCastleFipsProvider.getProviderDefaultSecurityStrength() / 2 + 1);
                final FipsSecureRandom fipsSecureRandom = bouncyCastleFipsProvider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(entropySource.getEntropy(), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        fipsSecureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        fipsSecureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n2) {
                        return fipsSecureRandom.generateSeed(n2);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }
}

