/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.jcajce.provider.DSAUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSAPrivateKey
implements DSAPrivateKey,
Destroyable,
ProvKey<AsymmetricDSAPrivateKey> {
    private static final long serialVersionUID = -4677259546958385734L;
    private transient AsymmetricDSAPrivateKey baseKey;

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKey dSAPrivateKey) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(dSAPrivateKey.getParams()), dSAPrivateKey.getX());
    }

    ProvDSAPrivateKey(Algorithm algorithm, DSAPrivateKeySpec dSAPrivateKeySpec) {
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, DSAUtils.extractParams(dSAPrivateKeySpec), dSAPrivateKeySpec.getX());
    }

    ProvDSAPrivateKey(AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        this.baseKey = asymmetricDSAPrivateKey;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public DSAParams getParams() {
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    @Override
    public AsymmetricDSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "DSA";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DSA");
        }
        try {
            return KeyUtil.privateKeyToString("DSA", this.baseKey.getX(), this.baseKey.getDomainParameters());
        }
        catch (Exception exception) {
            return KeyUtil.restrictedToString("DSA");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDSAPrivateKey)) {
            return false;
        }
        ProvDSAPrivateKey provDSAPrivateKey = (ProvDSAPrivateKey)object;
        return this.baseKey.equals(provDSAPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSAPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

