/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.jcajce.provider.DHUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;

class ProvDHPrivateKey
implements DHPrivateKey,
Destroyable {
    static final long serialVersionUID = 311058815616901812L;
    private transient AsymmetricDHPrivateKey baseKey;

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKey dHPrivateKey) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(dHPrivateKey.getParams()), dHPrivateKey.getX());
    }

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKeySpec dHPrivateKeySpec) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(dHPrivateKeySpec), dHPrivateKeySpec.getX());
    }

    ProvDHPrivateKey(AsymmetricDHPrivateKey asymmetricDHPrivateKey) {
        this.baseKey = asymmetricDHPrivateKey;
    }

    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "DH";
    }

    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public DHParameterSpec getParams() {
        return DHUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public BigInteger getX() {
        return this.baseKey.getX();
    }

    AsymmetricDHPrivateKey getBaseKey() {
        return this.baseKey;
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public void destroy() {
        this.baseKey.destroy();
    }

    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DH");
        }
        try {
            return KeyUtil.privateKeyToString("DH", this.baseKey.getX(), this.baseKey.getDomainParameters());
        }
        catch (Exception exception) {
            return KeyUtil.restrictedToString("DH");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDHPrivateKey)) {
            return false;
        }
        ProvDHPrivateKey provDHPrivateKey = (ProvDHPrivateKey)object;
        return this.baseKey.equals(provDHPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

