/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.params.DesParameters;

public class DesEdeParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public static boolean isWeakKey(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; i2 += 8) {
            if (!DesParameters.isWeakKey(byArray, i2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRealEDEKey(byte[] byArray) {
        return byArray.length == 16 ? DesEdeParameters.isReal2Key(byArray) : DesEdeParameters.isReal3Key(byArray);
    }

    public static boolean isReal2Key(byte[] byArray) {
        boolean bl2 = false;
        for (int i2 = 0; i2 != 8; ++i2) {
            if (byArray[i2] == byArray[i2 + 8]) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean isReal3Key(byte[] byArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i2 = 0; i2 != 8; ++i2) {
            bl2 |= byArray[i2] != byArray[i2 + 8];
            bl3 |= byArray[i2] != byArray[i2 + 16];
            bl4 |= byArray[i2 + 8] != byArray[i2 + 16];
        }
        return bl2 && bl3 && bl4;
    }

    public static boolean isActuallyDesKey(byte[] byArray) {
        boolean bl2 = true;
        if (byArray.length == 16) {
            for (int i2 = 0; i2 != 8; ++i2) {
                if (byArray[i2] == byArray[i2 + 8]) continue;
                bl2 = false;
            }
        } else {
            for (int i3 = 0; i3 != 8; ++i3) {
                if (byArray[i3] == byArray[i3 + 8] && byArray[i3 + 8] == byArray[i3 + 16]) continue;
                bl2 = false;
            }
        }
        return bl2;
    }
}

